/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.api.client.request.settings;

import com.takipi.api.client.data.advanced.AdvancedSettings;
import com.takipi.api.client.request.ServiceRequest;
import com.takipi.api.client.result.EmptyResult;
import com.takipi.api.core.request.intf.ApiPostRequest;
import com.takipi.common.util.JsonUtil;
import java.util.HashMap;

public class UpdateAdvancedSettingsRequest
extends ServiceRequest
implements ApiPostRequest<EmptyResult> {
    private final AdvancedSettings advancedSettings;
    private final boolean isShowLogLinksInitialized;

    protected UpdateAdvancedSettingsRequest(String serviceId, AdvancedSettings advancedSettings, boolean isShowLogLinksInitialized) {
        super(serviceId);
        this.advancedSettings = advancedSettings;
        this.isShowLogLinksInitialized = isShowLogLinksInitialized;
    }

    @Override
    public String postData() {
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.advancedSettings.allowed_ips != null) {
            map.put("allowed_ips", JsonUtil.stringify(this.advancedSettings.allowed_ips));
        }
        map.put("show_rethrows", Boolean.toString(this.advancedSettings.show_rethrows));
        if (this.isShowLogLinksInitialized) {
            map.put("show_log_links", Boolean.toString(this.advancedSettings.show_log_links));
        }
        map.put("clear_env_filters", Boolean.toString(this.advancedSettings.clear_env_filters));
        return JsonUtil.createSimpleJson(map, false);
    }

    @Override
    public Class<EmptyResult> resultClass() {
        return EmptyResult.class;
    }

    @Override
    public String urlPath() {
        return this.baseUrlPath() + "/settings/advanced-settings";
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    extends ServiceRequest.Builder {
        private String allowedIps;
        private boolean showRethrows;
        private boolean isShowLogLinksInitialized;
        private boolean showLogLinks;
        private boolean clearEnvFilters;

        Builder() {
        }

        @Override
        public Builder setServiceId(String serviceId) {
            super.setServiceId(serviceId);
            return this;
        }

        public Builder setAllowedIps(String allowedIps) {
            this.allowedIps = allowedIps;
            return this;
        }

        public Builder setShowRethrows(boolean showRethrows) {
            this.showRethrows = showRethrows;
            return this;
        }

        public Builder setShowLogLinks(boolean showLogLinks) {
            this.showLogLinks = showLogLinks;
            this.isShowLogLinksInitialized = true;
            return this;
        }

        public Builder setClearEnvFilters(boolean clearEnvFilters) {
            this.clearEnvFilters = clearEnvFilters;
            return this;
        }

        public UpdateAdvancedSettingsRequest build() {
            this.validate();
            AdvancedSettings advancedSettings = new AdvancedSettings();
            advancedSettings.allowed_ips = this.allowedIps;
            advancedSettings.show_rethrows = this.showRethrows;
            advancedSettings.show_log_links = this.showLogLinks;
            advancedSettings.clear_env_filters = this.clearEnvFilters;
            return new UpdateAdvancedSettingsRequest(this.serviceId, advancedSettings, this.isShowLogLinksInitialized);
        }
    }
}

