/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.api.client.request.view;

import com.takipi.api.client.request.ServiceRequest;
import com.takipi.api.client.result.EmptyResult;
import com.takipi.api.client.util.validation.ValidationUtil;
import com.takipi.api.core.request.intf.ApiDeleteRequest;

public class DeleteViewRequest
extends ServiceRequest
implements ApiDeleteRequest<EmptyResult> {
    private final String viewId;

    DeleteViewRequest(String serviceId, String viewId) {
        super(serviceId);
        this.viewId = viewId;
    }

    @Override
    public String urlPath() {
        return this.baseUrlPath() + "/views/" + this.viewId;
    }

    @Override
    public String postData() {
        return null;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public Class<EmptyResult> resultClass() {
        return EmptyResult.class;
    }

    public static class Builder
    extends ServiceRequest.Builder {
        private String viewId;

        Builder() {
        }

        @Override
        public Builder setServiceId(String serviceId) {
            super.setServiceId(serviceId);
            return this;
        }

        public Builder setViewId(String viewId) {
            this.viewId = viewId;
            return this;
        }

        @Override
        protected void validate() {
            super.validate();
            if (!ValidationUtil.isLegalViewId(this.viewId)) {
                throw new IllegalArgumentException("Illegal view id - " + this.viewId);
            }
        }

        public DeleteViewRequest build() {
            this.validate();
            return new DeleteViewRequest(this.serviceId, this.viewId);
        }
    }
}

