/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.api.client.request.view;

import com.takipi.api.client.request.ServiceRequest;
import com.takipi.api.client.result.view.ViewResult;
import com.takipi.api.client.util.validation.ValidationUtil;
import com.takipi.api.core.request.intf.ApiGetRequest;
import java.io.UnsupportedEncodingException;

public class ViewRequest
extends ServiceRequest
implements ApiGetRequest<ViewResult> {
    public final String viewId;

    ViewRequest(String serviceId, String viewId) {
        super(serviceId);
        this.viewId = viewId;
    }

    @Override
    public Class<ViewResult> resultClass() {
        return ViewResult.class;
    }

    @Override
    public String urlPath() {
        return this.baseUrlPath() + "/views/" + this.viewId;
    }

    @Override
    public String[] queryParams() throws UnsupportedEncodingException {
        return null;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    extends ServiceRequest.Builder {
        private String viewId;

        Builder() {
        }

        @Override
        public Builder setServiceId(String serviceId) {
            super.setServiceId(serviceId);
            return this;
        }

        public Builder setViewId(String viewId) {
            this.viewId = viewId;
            return this;
        }

        @Override
        protected void validate() {
            super.validate();
            if (!ValidationUtil.isLegalViewId(this.viewId)) {
                throw new IllegalArgumentException("Illegal view id - " + this.viewId);
            }
        }

        public ViewRequest build() {
            this.validate();
            return new ViewRequest(this.serviceId, this.viewId);
        }
    }
}

