/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.api.client.request.view;

import com.takipi.api.client.request.ServiceRequest;
import com.takipi.api.client.result.view.ViewsResult;
import com.takipi.api.core.request.intf.ApiGetRequest;
import com.takipi.common.util.StringUtil;
import java.io.UnsupportedEncodingException;

public class ViewsRequest
extends ServiceRequest
implements ApiGetRequest<ViewsResult> {
    public final String viewName;

    ViewsRequest(String serviceId, String viewName) {
        super(serviceId);
        this.viewName = viewName;
    }

    @Override
    public Class<ViewsResult> resultClass() {
        return ViewsResult.class;
    }

    @Override
    public String urlPath() {
        return this.baseUrlPath() + "/views";
    }

    @Override
    public String[] queryParams() throws UnsupportedEncodingException {
        if (StringUtil.isNullOrEmpty(this.viewName)) {
            return null;
        }
        String[] params = new String[]{"name=" + ViewsRequest.encode(this.viewName)};
        return params;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    extends ServiceRequest.Builder {
        private String viewName;

        Builder() {
        }

        @Override
        public Builder setServiceId(String serviceId) {
            super.setServiceId(serviceId);
            return this;
        }

        public Builder setViewName(String viewName) {
            this.viewName = viewName;
            return this;
        }

        public ViewsRequest build() {
            this.validate();
            return new ViewsRequest(this.serviceId, this.viewName);
        }
    }
}

