/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.api.client.util.validation;

import com.takipi.common.util.StringUtil;

public class ValidationUtil {
    public static boolean isLegalServiceId(String serviceId) {
        return ValidationUtil.isLegalId(serviceId, "S");
    }

    public static boolean isLegalViewId(String viewId) {
        return ValidationUtil.isLegalId(viewId, "P");
    }

    public static boolean isLegalEventId(String eventId) {
        return ValidationUtil.isLegalId(eventId, "K") || ValidationUtil.isInteger(eventId);
    }

    public static boolean isLegalLibraryId(String serviceId) {
        return ValidationUtil.isLegalId(serviceId, "L");
    }

    public static boolean isLegalId(String id, String prefix) {
        if (StringUtil.isNullOrEmpty(id)) {
            return false;
        }
        if (!id.startsWith(prefix)) {
            return false;
        }
        return ValidationUtil.isInteger(id.substring(prefix.length()));
    }

    private static boolean isInteger(String s) {
        try {
            Integer.parseInt(s);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static enum UserRole {
        owner,
        admin,
        member,
        viewer;

    }

    public static enum GraphResolution {
        M1,
        M5,
        H1,
        H8;

    }

    public static enum VolumeType {
        hits,
        invocations,
        all;

    }

    public static enum GraphType {
        view,
        entrypoint,
        event;

    }
}

