/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.api.core.url;

import com.takipi.common.util.StringUtil;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UrlClient {
    protected static final Logger logger = LoggerFactory.getLogger(UrlClient.class);
    static final Response<String> BAD_RESPONSE = Response.of(500, null);
    private final String hostname;
    private final int connectTimeout;
    private final int readTimeout;
    private final LogLevel defaultLogLevel;
    private final Map<Integer, LogLevel> responseLogLevels;

    protected UrlClient(String hostname, int connectTimeout, int readTimeout, LogLevel defaultLogLevel, Map<Integer, LogLevel> responseLogLevels) {
        this.hostname = hostname;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.defaultLogLevel = defaultLogLevel;
        this.responseLogLevels = responseLogLevels;
    }

    public String getHostname() {
        return this.hostname;
    }

    protected String appendQueryParams(String url, String[] params) {
        if (params == null || params.length == 0) {
            return url;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(url);
        boolean first = true;
        for (String param : params) {
            if (StringUtil.isNullOrEmpty(param)) continue;
            char prefix = first ? (char)'?' : '&';
            sb.append(prefix);
            sb.append(param);
            first = false;
        }
        return sb.toString();
    }

    protected HttpURLConnection getConnection(String targetUrl, String contentType, String[] params) throws Exception {
        URL url = new URL(this.appendQueryParams(targetUrl, params));
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Content-Type", contentType);
        connection.setConnectTimeout(this.connectTimeout);
        connection.setReadTimeout(this.readTimeout);
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response<String> get(String targetUrl, String contentType, String ... params) {
        HttpURLConnection connection = null;
        try {
            Response<String> result;
            connection = this.getConnection(targetUrl, contentType, params);
            connection.setRequestMethod("GET");
            Response<String> response = result = this.getResponse(targetUrl, connection);
            this.closeQuietly(connection);
            return response;
        }
        catch (Exception ex) {
            try {
                logger.error("Url client GET {} failed.", (Object)targetUrl, (Object)ex);
                Response<String> response = BAD_RESPONSE;
                this.closeQuietly(connection);
                return response;
            }
            catch (Throwable throwable) {
                this.closeQuietly(connection);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response<String> put(String targetUrl, byte[] data, String contentType, String ... params) {
        HttpURLConnection connection = null;
        try {
            Response<String> result;
            connection = this.getConnection(targetUrl, contentType, params);
            connection.setRequestProperty("Accept", "application/json");
            connection.setDoOutput(true);
            connection.setRequestMethod("PUT");
            if (data != null && data.length > 0) {
                OutputStream out = connection.getOutputStream();
                out.write(data);
                out.flush();
                out.close();
            }
            Response<String> response = result = this.getResponse(targetUrl, connection);
            this.closeQuietly(connection);
            return response;
        }
        catch (Exception ex) {
            try {
                logger.error("Url client POST {} failed.", (Object)targetUrl, (Object)ex);
                Response<String> response = BAD_RESPONSE;
                this.closeQuietly(connection);
                return response;
            }
            catch (Throwable throwable) {
                this.closeQuietly(connection);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response<String> post(String targetUrl, byte[] data, String contentType, String ... params) {
        HttpURLConnection connection = null;
        try {
            Response<String> result;
            connection = this.getConnection(targetUrl, contentType, params);
            connection.setRequestProperty("Accept", "application/json");
            connection.setDoOutput(true);
            connection.setRequestMethod("POST");
            if (data != null && data.length > 0) {
                OutputStream out = connection.getOutputStream();
                out.write(data);
                out.flush();
                out.close();
            }
            Response<String> response = result = this.getResponse(targetUrl, connection);
            this.closeQuietly(connection);
            return response;
        }
        catch (Exception ex) {
            try {
                logger.error("Url client POST {} failed.", (Object)targetUrl, (Object)ex);
                Response<String> response = BAD_RESPONSE;
                this.closeQuietly(connection);
                return response;
            }
            catch (Throwable throwable) {
                this.closeQuietly(connection);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response<String> delete(String targetUrl, byte[] data, String contentType, String ... params) {
        HttpURLConnection connection = null;
        try {
            Response<String> result;
            connection = this.getConnection(targetUrl, contentType, params);
            connection.setDoOutput(true);
            connection.setRequestMethod("DELETE");
            if (data != null && data.length > 0) {
                OutputStream out = connection.getOutputStream();
                out.write(data);
                out.flush();
                out.close();
            }
            Response<String> response = result = this.getResponse(targetUrl, connection);
            this.closeQuietly(connection);
            return response;
        }
        catch (Exception ex) {
            try {
                logger.error("Url client DELETE {} failed.", (Object)targetUrl, (Object)ex);
                Response<String> response = BAD_RESPONSE;
                this.closeQuietly(connection);
                return response;
            }
            catch (Throwable throwable) {
                this.closeQuietly(connection);
                throw throwable;
            }
        }
    }

    private Response<String> getResponse(String targetUrl, HttpURLConnection connection) {
        try {
            String responseData;
            int responseCode = connection.getResponseCode();
            if (!UrlClient.isBadResponse(responseCode)) {
                responseData = this.parseInputStream(connection.getInputStream());
            } else {
                responseData = this.parseInputStream(connection.getErrorStream());
                this.logBadResponse(responseData, responseCode, targetUrl);
            }
            return Response.of(responseCode, responseData);
        }
        catch (Exception ex) {
            logger.error("Error parsing response from {}.", (Object)targetUrl, (Object)ex);
            return BAD_RESPONSE;
        }
    }

    private void logBadResponse(String responseData, int responseCode, String targetUrl) {
        LogLevel logLevel = this.responseLogLevels.get(responseCode);
        if (logLevel == null) {
            logLevel = this.defaultLogLevel;
        }
        if (logLevel == LogLevel.NONE) {
            return;
        }
        String errorMessage = responseData;
        if (StringUtil.isNullOrEmpty(errorMessage)) {
            errorMessage = "No error message received";
        }
        String prettyErrorMessage = this.prettifyErrorMessage(errorMessage, responseCode, 2000);
        switch (logLevel) {
            case DEBUG: {
                logger.debug("url client returns with bad response. url={}, code={}, error={}.", new Object[]{targetUrl, responseCode, prettyErrorMessage});
                break;
            }
            case INFO: {
                logger.info("url client returns with bad response. url={}, code={}, error={}.", new Object[]{targetUrl, responseCode, prettyErrorMessage});
                break;
            }
            case WARN: {
                logger.warn("url client returns with bad response. url={}, code={}, error={}.", new Object[]{targetUrl, responseCode, prettyErrorMessage});
                break;
            }
            case ERROR: {
                logger.error("url client returns with bad response. url={}, code={}, error={}.", new Object[]{targetUrl, responseCode, prettyErrorMessage});
                break;
            }
            default: {
                logger.error("url client returns with bad response. url={}, code={}, error={}.", new Object[]{targetUrl, responseCode, prettyErrorMessage});
            }
        }
    }

    private String prettifyErrorMessage(String errorMessage, int responseCode, int maxMessageLength) {
        if (responseCode == 401) {
            return "N/A";
        }
        String squashedString = this.squashString(errorMessage);
        return this.ellipsize(squashedString, maxMessageLength);
    }

    private String squashString(String str) {
        return str.replaceAll("[\\n\\r\\s]+", " ");
    }

    private String ellipsize(String str, int targetLength) {
        return this.ellipsize(str, targetLength, 1.0);
    }

    private String ellipsize(String str, int targetLength, double location) {
        return this.ellipsize(str, targetLength, location, "...");
    }

    private String ellipsize(String str, int targetLength, double location, String placeholder) {
        if (str.length() <= targetLength) {
            return str;
        }
        int netLength = targetLength - placeholder.length();
        int leftLength = (int)Math.round((double)netLength * location);
        int rightLength = netLength - leftLength;
        String leftStr = str.substring(0, leftLength);
        String rightStr = str.substring(str.length() - rightLength);
        return leftStr + placeholder + rightStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String parseInputStream(InputStream is) {
        if (is == null) {
            return null;
        }
        InputStreamReader isr = null;
        try {
            isr = new InputStreamReader(is, "UTF-8");
            String string = IOUtils.toString((Reader)isr);
            this.closeQuietly(isr);
            return string;
        }
        catch (Exception ex) {
            try {
                String string = null;
                this.closeQuietly(isr);
                return string;
            }
            catch (Throwable throwable) {
                this.closeQuietly(isr);
                throw throwable;
            }
        }
    }

    private void closeQuietly(HttpURLConnection connection) {
        if (connection != null) {
            try {
                connection.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void closeQuietly(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static boolean isBadResponse(int responseCode) {
        return responseCode >= 300;
    }

    public static class Response<T> {
        public final int responseCode;
        public final T data;

        private Response(int responseCode, T data) {
            this.responseCode = responseCode;
            this.data = data;
        }

        public boolean isOK() {
            return !this.isBadResponse();
        }

        public boolean isBadResponse() {
            return UrlClient.isBadResponse(this.responseCode);
        }

        public static <T> Response<T> of(int responseCode, T data) {
            return new Response<T>(responseCode, data);
        }
    }

    public static enum LogLevel {
        NONE,
        DEBUG,
        INFO,
        WARN,
        ERROR;

    }
}

