/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.common.util;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.text.StringCharacterIterator;
import java.util.Map;

public class JsonUtil {
    private static final String JSON_PREFIX = "{";
    private static final String JSON_SUFFIX = "}";

    public static String stringify(String s) {
        return "\"" + s + "\"";
    }

    public static String createSimpleJson(Iterable<String> arr) {
        return JsonUtil.createSimpleJson(arr, false);
    }

    public static String createSimpleJson(Iterable<String> arr, boolean stringifyValues) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        boolean isFirst = true;
        for (String entry : arr) {
            if (!isFirst) {
                sb.append(",");
            }
            if (stringifyValues) {
                sb.append(JsonUtil.stringify(entry));
            } else {
                sb.append(entry);
            }
            isFirst = false;
        }
        sb.append("]\n");
        return sb.toString();
    }

    public static String createSimpleJson(Map<String, String> map) {
        return JsonUtil.createSimpleJson(map, false);
    }

    public static String createSimpleJson(Map<String, String> map, boolean stringifyValues) {
        StringBuilder sb = new StringBuilder();
        sb.append(JSON_PREFIX);
        boolean isFirst = true;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (!isFirst) {
                sb.append(",");
            }
            sb.append("\n\t");
            sb.append("\"" + key + "\": ");
            if (stringifyValues) {
                sb.append(JsonUtil.stringify(value));
            } else {
                sb.append(value);
            }
            isFirst = false;
        }
        sb.append("\n}\n");
        return sb.toString();
    }

    public static boolean isLegalJson(String jsonStr) {
        if (!jsonStr.startsWith(JSON_PREFIX) || !jsonStr.endsWith(JSON_SUFFIX)) {
            return false;
        }
        try {
            Gson gson = new Gson();
            gson.fromJson(jsonStr, Object.class);
            return true;
        }
        catch (JsonSyntaxException e) {
            return false;
        }
    }

    public static String escapeText(String input) {
        StringBuilder builder = new StringBuilder(input.length());
        StringCharacterIterator iter = new StringCharacterIterator(input);
        char c = iter.first();
        while (c != '\uffff') {
            switch (c) {
                case '\b': {
                    builder.append("\\b");
                    break;
                }
                case '\f': {
                    builder.append("\\f");
                    break;
                }
                case '\n': {
                    builder.append("\\n");
                    break;
                }
                case '\r': {
                    builder.append("\\r");
                    break;
                }
                case '\t': {
                    builder.append("\\t");
                    break;
                }
                case '\\': {
                    builder.append("\\\\");
                    break;
                }
                case '\"': {
                    builder.append("\\\"");
                    break;
                }
                default: {
                    if (c >= '\u0000' && c <= '\u001f') {
                        JsonUtil.appendEscapedUnicode(builder, c);
                        break;
                    }
                    if (Character.isHighSurrogate(c)) {
                        JsonUtil.appendEscapedUnicode(builder, c);
                        c = iter.next();
                        if (c == '\uffff') {
                            throw new IllegalArgumentException("invalid unicode string: unexpected high surrogate pair value without corresponding low value.");
                        }
                        JsonUtil.appendEscapedUnicode(builder, c);
                        break;
                    }
                    builder.append(c);
                }
            }
            c = iter.next();
        }
        return builder.toString();
    }

    private static void appendEscapedUnicode(StringBuilder builder, char ch) {
        String prefix = "\\u";
        if (ch < '\u0010') {
            prefix = "\\u000";
        } else if (ch < '\u0100') {
            prefix = "\\u00";
        } else if (ch < '\u1000') {
            prefix = "\\u0";
        }
        builder.append(prefix).append(Integer.toHexString(ch));
    }
}

