/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.api.client;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.takipi.api.client.observe.Observer;
import com.takipi.api.core.request.intf.ApiDeleteRequest;
import com.takipi.api.core.request.intf.ApiGetRequest;
import com.takipi.api.core.request.intf.ApiPostBytesRequest;
import com.takipi.api.core.request.intf.ApiPostRequest;
import com.takipi.api.core.request.intf.ApiPutRequest;
import com.takipi.api.core.request.intf.ApiRequest;
import com.takipi.api.core.result.intf.ApiResult;
import com.takipi.api.core.url.UrlClient;
import com.takipi.common.util.CollectionUtil;
import com.takipi.common.util.ObjectUtil;
import com.takipi.common.util.Pair;
import com.takipi.common.util.StringUtil;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;

public abstract class BaseApiClient
extends UrlClient {
    private static final Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
    private final Pair<String, String> auth;
    private final Object observerLock;
    private volatile List<Observer> observers;

    protected BaseApiClient(String hostname, Pair<String, String> auth, int connectTimeout, int readTimeout, UrlClient.LogLevel defaultLogLevel, Map<Integer, UrlClient.LogLevel> responseLogLevels, Collection<Observer> observers) {
        super(hostname, connectTimeout, readTimeout, defaultLogLevel, responseLogLevels);
        this.auth = auth;
        this.observerLock = new Object();
        if (!CollectionUtil.safeIsEmpty(observers)) {
            this.observers = new ArrayList<Observer>(observers);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BaseApiClient)) {
            return false;
        }
        BaseApiClient other = (BaseApiClient)obj;
        if (!ObjectUtil.equal(this.getHostname(), other.getHostname())) {
            return false;
        }
        return ObjectUtil.equal(this.auth, other.auth);
    }

    public int hashCode() {
        return this.getHostname().hashCode() ^ this.auth.hashCode();
    }

    protected abstract String baseApiPath();

    protected String buildTargetUrl(ApiRequest apiRequest) throws UnsupportedEncodingException {
        return this.baseApiPath() + apiRequest.urlPath();
    }

    @Override
    protected HttpURLConnection getConnection(String targetUrl, String contentType, String[] params) throws Exception {
        HttpURLConnection connection = super.getConnection(targetUrl, contentType, params);
        if (connection == null) {
            return null;
        }
        if (this.auth != null) {
            connection.setRequestProperty(this.auth.getFirst(), this.auth.getSecond());
        }
        return connection;
    }

    public <T extends ApiResult> UrlClient.Response<T> get(ApiGetRequest<T> request) {
        try {
            long t1 = System.currentTimeMillis();
            UrlClient.Response<String> response = this.get(this.buildTargetUrl(request), request.contentType(), request.queryParams());
            long t2 = System.currentTimeMillis();
            this.observe(Observer.Operation.GET, this.appendQueryParams(request.urlPath(), request.queryParams()), null, (String)response.data, response.responseCode, t2 - t1);
            return this.getApiResponse(response, request.resultClass());
        }
        catch (Exception e) {
            logger.error("Api url client GET {} failed.", (Object)request.getClass().getName(), (Object)e);
            return UrlClient.Response.of(500, null);
        }
    }

    public <T extends ApiResult> UrlClient.Response<T> put(ApiPutRequest<T> request) {
        try {
            long t1 = System.currentTimeMillis();
            UrlClient.Response<String> response = this.put(this.buildTargetUrl(request), request.putData(), request.contentType(), request.queryParams());
            long t2 = System.currentTimeMillis();
            this.observe(Observer.Operation.PUT, this.appendQueryParams(request.urlPath(), request.queryParams()), this.prettyBytes(request.putData()), (String)response.data, response.responseCode, t2 - t1);
            return this.getApiResponse(response, request.resultClass());
        }
        catch (Exception e) {
            logger.error("Api url client PUT {} failed.", (Object)request.getClass().getName(), (Object)e);
            return UrlClient.Response.of(500, null);
        }
    }

    public <T extends ApiResult> UrlClient.Response<T> post(ApiPostRequest<T> request) {
        try {
            String postData = request.postData();
            byte[] data = StringUtil.isNullOrEmpty(postData) ? null : postData.getBytes("UTF-8");
            long t1 = System.currentTimeMillis();
            UrlClient.Response<String> response = this.post(this.buildTargetUrl(request), data, request.contentType(), request.queryParams());
            long t2 = System.currentTimeMillis();
            this.observe(Observer.Operation.POST, this.appendQueryParams(request.urlPath(), request.queryParams()), postData, (String)response.data, response.responseCode, t2 - t1);
            return this.getApiResponse(response, request.resultClass());
        }
        catch (Exception e) {
            logger.error("Api url client POST {} failed.", (Object)request.getClass().getName(), (Object)e);
            return UrlClient.Response.of(500, null);
        }
    }

    public <T extends ApiResult> UrlClient.Response<T> post(ApiPostBytesRequest<T> request) {
        try {
            long t1 = System.currentTimeMillis();
            UrlClient.Response<String> response = this.post(this.buildTargetUrl(request), request.postData(), request.contentType(), request.queryParams());
            long t2 = System.currentTimeMillis();
            this.observe(Observer.Operation.POST, this.appendQueryParams(request.urlPath(), request.queryParams()), this.prettyBytes(request.postData()), (String)response.data, response.responseCode, t2 - t1);
            return this.getApiResponse(response, request.resultClass());
        }
        catch (Exception e) {
            logger.error("Api url client POST {} failed.", (Object)request.getClass().getName(), (Object)e);
            return UrlClient.Response.of(500, null);
        }
    }

    public <T extends ApiResult> UrlClient.Response<T> delete(ApiDeleteRequest<T> request) {
        try {
            String postData = request.postData();
            byte[] data = StringUtil.isNullOrEmpty(postData) ? null : postData.getBytes("UTF-8");
            long t1 = System.currentTimeMillis();
            UrlClient.Response<String> response = this.delete(this.buildTargetUrl(request), data, request.contentType(), request.queryParams());
            long t2 = System.currentTimeMillis();
            this.observe(Observer.Operation.DELETE, this.appendQueryParams(request.urlPath(), request.queryParams()), null, (String)response.data, response.responseCode, t2 - t1);
            return this.getApiResponse(response, request.resultClass());
        }
        catch (Exception e) {
            logger.error("Api url client DELETE {} failed.", (Object)request.getClass().getName(), (Object)e);
            return UrlClient.Response.of(500, null);
        }
    }

    private <T extends ApiResult> UrlClient.Response<T> getApiResponse(UrlClient.Response<String> response, Class<T> clazz) {
        if (response.isBadResponse() || StringUtil.isNullOrEmpty((String)response.data)) {
            return UrlClient.Response.of(response.responseCode, null);
        }
        ApiResult apiResult = (ApiResult)GSON.fromJson((String)response.data, clazz);
        return UrlClient.Response.of(response.responseCode, apiResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObserver(Observer observer) {
        if (observer == null) {
            throw new IllegalArgumentException("observer");
        }
        Object object = this.observerLock;
        synchronized (object) {
            ArrayList<Observer> observers = this.observers != null ? new ArrayList<Observer>(this.observers) : new ArrayList<Observer>();
            observers.add(observer);
            this.observers = observers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObserver(Observer observer) {
        if (observer == null) {
            throw new IllegalArgumentException("observer");
        }
        Object object = this.observerLock;
        synchronized (object) {
            if (this.observers != null && this.observers.contains(observer)) {
                ArrayList<Observer> observers = new ArrayList<Observer>(this.observers);
                observers.remove(observer);
                this.observers = observers;
            }
        }
    }

    private void observe(Observer.Operation operation, String url, String request, String response, int responseCode, long time) {
        List<Observer> observers = this.observers;
        if (observers == null) {
            return;
        }
        for (Observer observer : observers) {
            observer.observe(operation, url, request, response, responseCode, time);
        }
    }

    private String prettyBytes(byte[] bytes) {
        StringBuilder builder = new StringBuilder();
        builder.append("Binary data (");
        builder.append(bytes != null ? bytes.length : 0);
        builder.append(")");
        return builder.toString();
    }

    public static class Builder {
        private static final int CONNECT_TIMEOUT = 15000;
        private static final int READ_TIMEOUT = 60000;
        protected String hostname;
        protected String username;
        protected String password;
        protected String apiKey;
        protected int connectTimeout = 15000;
        protected int readTimeout = 60000;
        protected UrlClient.LogLevel defaultLogLevel = UrlClient.LogLevel.ERROR;
        protected Map<Integer, UrlClient.LogLevel> responseLogLevels = new HashMap<Integer, UrlClient.LogLevel>();
        protected Collection<Observer> observers = new HashSet<Observer>();

        protected Builder() {
        }

        public Builder setHostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public Builder setUsername(String username) {
            this.username = username;
            return this;
        }

        public Builder setPassword(String password) {
            this.password = password;
            return this;
        }

        public Builder setApiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder setConnectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder setReadTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public Builder setDefaultLogLevel(UrlClient.LogLevel defaultLogLevel) {
            this.defaultLogLevel = defaultLogLevel;
            return this;
        }

        public Builder setResponseLogLevel(int responseCode, UrlClient.LogLevel logLevel) {
            this.responseLogLevels.put(responseCode, logLevel);
            return this;
        }

        public Builder addObserver(Observer observer) {
            this.observers.add(observer);
            return this;
        }

        protected Pair<String, String> getAuth() {
            if (!StringUtil.isNullOrEmpty(this.apiKey)) {
                return Pair.of("X-API-Key", this.apiKey);
            }
            if (StringUtil.isNullOrEmpty(this.username)) {
                throw new IllegalArgumentException("Missing username/api key");
            }
            if (StringUtil.isNullOrEmpty(this.password)) {
                throw new IllegalArgumentException("Missing password");
            }
            String userPassword = this.username + ":" + this.password;
            byte[] userPasswordBytes = userPassword.getBytes();
            Base64 base64 = new Base64();
            byte[] encodedData = base64.encode(userPasswordBytes);
            String auth = "Basic " + new String(encodedData);
            return Pair.of("Authorization", auth);
        }
    }
}

