/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.api.client.data.alert;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Anomaly {
    private final List<AnomalyPeriod> anomalyPeriods = new ArrayList<AnomalyPeriod>();
    private final List<AnomalyContributor> anomalyContributors = new ArrayList<AnomalyContributor>();

    private Anomaly() {
    }

    public void addAnomalyPeriod(String id, long fromTimestamp, long toTimestamp) {
        this.anomalyPeriods.add(AnomalyPeriod.of(id, fromTimestamp, toTimestamp));
    }

    public boolean isEmpty() {
        return this.anomalyPeriods.isEmpty();
    }

    public int periodsCount() {
        return this.anomalyPeriods.size();
    }

    public List<AnomalyPeriod> getAnomalyPeriods() {
        return Collections.unmodifiableList(this.anomalyPeriods);
    }

    public void addContributor(int id, long value) {
        this.anomalyContributors.add(AnomalyContributor.of(id, value));
    }

    public int contributorsCount() {
        return this.anomalyContributors.size();
    }

    public List<AnomalyContributor> getAnomalyContributors() {
        return Collections.unmodifiableList(this.anomalyContributors);
    }

    public static Anomaly create() {
        return new Anomaly();
    }

    public static class AnomalyContributor {
        public final int id;
        public final long value;

        private AnomalyContributor(int id, long value) {
            this.id = id;
            this.value = value;
        }

        static AnomalyContributor of(int id, long value) {
            return new AnomalyContributor(id, value);
        }
    }

    public static class AnomalyPeriod {
        public final String id;
        public final long fromTimestamp;
        public final long toTimestamp;

        private AnomalyPeriod(String id, long fromTimestamp, long toTimestamp) {
            this.id = id;
            this.fromTimestamp = fromTimestamp;
            this.toTimestamp = toTimestamp;
        }

        static AnomalyPeriod of(String id, long fromTimestamp, long toTimestamp) {
            return new AnomalyPeriod(id, fromTimestamp, toTimestamp);
        }
    }
}

