/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.api.client.request;

import com.takipi.api.client.request.BaseRequest;
import com.takipi.api.client.util.validation.ValidationUtil;

public abstract class ServiceRequest
extends BaseRequest {
    public final String serviceId;

    protected ServiceRequest(String serviceId) {
        this.serviceId = serviceId;
    }

    protected String baseUrlPath() {
        return "/services/" + this.serviceId;
    }

    public static class Builder {
        protected String serviceId;

        protected Builder() {
        }

        public Builder setServiceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        protected void validate() {
            if (!ValidationUtil.isLegalServiceId(this.serviceId)) {
                throw new IllegalArgumentException("Illegal service id - " + this.serviceId);
            }
        }
    }
}

