/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.api.client.request.alert;

import com.takipi.api.client.data.alert.Anomaly;
import com.takipi.api.client.request.alert.AlertRequest;
import com.takipi.common.util.CollectionUtil;
import com.takipi.common.util.JsonUtil;
import com.takipi.common.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class AnomalyAlertRequest
extends AlertRequest {
    private final String desc;
    private final String from;
    private final String to;
    private final String prettyTimeframe;
    private final Anomaly anomaly;

    protected AnomalyAlertRequest(String serviceId, String viewId, String desc, String from, String to, String prettyTimeframe, Anomaly anomaly) {
        super(serviceId, viewId);
        this.desc = desc;
        this.from = from;
        this.to = to;
        this.prettyTimeframe = prettyTimeframe;
        this.anomaly = anomaly;
    }

    @Override
    public String urlPath() {
        return this.baseUrlPath() + "/anomaly";
    }

    @Override
    public String postData() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("desc", JsonUtil.stringify(this.desc));
        map.put("timeframe", this.timeframeJson());
        map.put("anomaly", this.anomalyJson());
        return JsonUtil.createSimpleJson(map, false);
    }

    private String timeframeJson() {
        return JsonUtil.createSimpleJson(CollectionUtil.mapOf("from", this.from, "to", this.to, "name", StringUtil.nullToEmpty(this.prettyTimeframe)), true);
    }

    private String anomalyJson() {
        ArrayList<String> periodsJsons = new ArrayList<String>(this.anomaly.periodsCount());
        for (Anomaly.AnomalyPeriod period : this.anomaly.getAnomalyPeriods()) {
            periodsJsons.add(JsonUtil.createSimpleJson(CollectionUtil.mapOf("id", period.id, "from", new DateTime(period.fromTimestamp).toString(), "to", new DateTime(period.toTimestamp).toString()), true));
        }
        ArrayList<String> contributorsJsons = new ArrayList<String>(this.anomaly.contributorsCount());
        for (Anomaly.AnomalyContributor contributor : this.anomaly.getAnomalyContributors()) {
            contributorsJsons.add(JsonUtil.createSimpleJson(CollectionUtil.mapOf("id", String.valueOf(contributor.id), "value", String.valueOf(contributor.value))));
        }
        return JsonUtil.createSimpleJson(CollectionUtil.mapOf("periods", JsonUtil.createSimpleJson(periodsJsons), "contributors", JsonUtil.createSimpleJson(contributorsJsons)));
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    extends AlertRequest.Builder {
        private String desc;
        private String from;
        private String to;
        private String prettyTimeframe;
        private Anomaly anomaly;

        Builder() {
        }

        @Override
        public Builder setServiceId(String serviceId) {
            super.setServiceId(serviceId);
            return this;
        }

        @Override
        public Builder setViewId(String viewId) {
            super.setViewId(viewId);
            return this;
        }

        public Builder setDesc(String desc) {
            this.desc = desc;
            return this;
        }

        public Builder setFrom(String from) {
            this.from = from;
            return this;
        }

        public Builder setTo(String to) {
            this.to = to;
            return this;
        }

        public Builder setPrettyTimeframe(String prettyTimeframe) {
            this.prettyTimeframe = prettyTimeframe;
            return this;
        }

        public Builder setAnomaly(Anomaly anomaly) {
            this.anomaly = anomaly;
            return this;
        }

        @Override
        protected void validate() {
            DateTime toDate;
            DateTime fromDate;
            super.validate();
            if (StringUtil.isNullOrEmpty(this.desc)) {
                throw new IllegalArgumentException("Empty description");
            }
            try {
                fromDate = DateTime.parse((String)this.from);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Illegal from date - " + this.from, e);
            }
            try {
                toDate = DateTime.parse((String)this.to);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Illegal to date - " + this.from, e);
            }
            if (!fromDate.isBefore((ReadableInstant)toDate)) {
                throw new IllegalArgumentException("From date " + this.from + " must be before to date " + this.to);
            }
            if (this.anomaly == null) {
                throw new IllegalArgumentException("No anomaly set");
            }
        }

        public AnomalyAlertRequest build() {
            this.validate();
            return new AnomalyAlertRequest(this.serviceId, this.viewId, this.desc, this.from, this.to, this.prettyTimeframe, this.anomaly);
        }
    }
}

