/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.api.client.request.alert;

import com.google.gson.Gson;
import com.takipi.api.client.request.alert.AlertRequest;
import com.takipi.common.util.CollectionUtil;
import com.takipi.common.util.JsonUtil;
import com.takipi.common.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class CustomAlertRequest
extends AlertRequest {
    public final String title;
    public final String body;
    public final List<AlertLink> links;

    protected CustomAlertRequest(String serviceId, String viewId, String title, String body, List<AlertLink> links) {
        super(serviceId, viewId);
        this.title = title;
        this.body = body;
        this.links = new ArrayList<AlertLink>(links);
    }

    @Override
    public String urlPath() {
        return this.baseUrlPath() + "/custom-alert";
    }

    @Override
    public String postData() {
        HashMap<String, String> map = new HashMap<String, String>();
        if (!StringUtil.isNullOrEmpty(this.title)) {
            map.put("title", JsonUtil.stringify(this.title));
        }
        map.put("body", JsonUtil.stringify(this.body));
        if (!CollectionUtil.safeIsEmpty(this.links)) {
            ArrayList<String> jsons = new ArrayList<String>(this.links.size());
            for (AlertLink link : this.links) {
                jsons.add(link.toJson());
            }
            map.put("links", JsonUtil.createSimpleJson(jsons, false));
        }
        return JsonUtil.createSimpleJson(map, false);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class AlertLink {
        final String pre_link_text;
        final String link_text;
        final String post_link_text;
        final String link;

        private AlertLink(String preLinkText, String linkText, String postLinkText, String link) {
            this.pre_link_text = preLinkText;
            this.link_text = linkText;
            this.post_link_text = postLinkText;
            this.link = link;
        }

        public String toJson() {
            return new Gson().toJson((Object)this);
        }

        public static AlertLink create(String preLinkText, String linkText, String postLinkText, String link) {
            return new AlertLink(preLinkText, linkText, postLinkText, link);
        }
    }

    public static class Builder
    extends AlertRequest.Builder {
        private String title;
        private String body;
        private final List<AlertLink> links = new ArrayList<AlertLink>();

        Builder() {
        }

        @Override
        public Builder setServiceId(String serviceId) {
            super.setServiceId(serviceId);
            return this;
        }

        @Override
        public Builder setViewId(String viewId) {
            super.setViewId(viewId);
            return this;
        }

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder setBody(String body) {
            this.body = body;
            return this;
        }

        public Builder addLink(String linkText, String link) {
            return this.addLink(null, linkText, null, link);
        }

        public Builder addLink(String preLinkText, String linkText, String postLinkText, String link) {
            if (StringUtil.isNullOrEmpty(linkText)) {
                throw new IllegalArgumentException("Empty link text");
            }
            if (StringUtil.isNullOrEmpty(link)) {
                throw new IllegalArgumentException("Empty link");
            }
            return this.addLink(AlertLink.create(preLinkText, linkText, postLinkText, link));
        }

        public Builder addLink(AlertLink alertLink) {
            this.links.add(alertLink);
            return this;
        }

        @Override
        protected void validate() {
            super.validate();
            if (StringUtil.isNullOrEmpty(this.body)) {
                throw new IllegalArgumentException("Empty alert body");
            }
        }

        public CustomAlertRequest build() {
            this.validate();
            return new CustomAlertRequest(this.serviceId, this.viewId, this.title, this.body, this.links);
        }
    }
}

