/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.api.client.request.label;

import com.takipi.api.client.request.ServiceRequest;
import com.takipi.api.client.result.EmptyResult;
import com.takipi.api.core.request.intf.ApiPostRequest;
import com.takipi.common.util.JsonUtil;
import com.takipi.common.util.StringUtil;
import java.util.HashMap;

public class CreateLabelRequest
extends ServiceRequest
implements ApiPostRequest<EmptyResult> {
    private final String name;
    private final String color;

    CreateLabelRequest(String serviceId, String name, String color) {
        super(serviceId);
        this.name = name;
        this.color = color;
    }

    @Override
    public String urlPath() {
        return this.baseUrlPath() + "/labels";
    }

    @Override
    public String postData() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", this.name);
        if (!StringUtil.isNullOrEmpty(this.color)) {
            map.put("color", this.color);
        }
        return JsonUtil.createSimpleJson(map, true);
    }

    @Override
    public Class<EmptyResult> resultClass() {
        return EmptyResult.class;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    extends ServiceRequest.Builder {
        private String name;
        private String color;

        Builder() {
        }

        @Override
        public Builder setServiceId(String serviceId) {
            super.setServiceId(serviceId);
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setColor(String color) {
            this.color = color;
            return this;
        }

        @Override
        protected void validate() {
            super.validate();
            if (StringUtil.isNullOrEmpty(this.name)) {
                throw new IllegalArgumentException("Missing name");
            }
        }

        public CreateLabelRequest build() {
            this.validate();
            return new CreateLabelRequest(this.serviceId, this.name, this.color);
        }
    }
}

