/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.api.client.request.metrics;

import com.takipi.api.client.request.BreakdownViewTimeframeRequest;
import com.takipi.api.client.request.event.BreakdownType;
import com.takipi.api.client.result.metrics.GraphResult;
import com.takipi.api.client.util.validation.ValidationUtil;
import com.takipi.api.core.request.intf.ApiGetRequest;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Set;

public class GraphRequest
extends BreakdownViewTimeframeRequest
implements ApiGetRequest<GraphResult> {
    public final ValidationUtil.GraphType graphType;
    public final ValidationUtil.VolumeType volumeType;
    public final int wantedPointCount;
    public final ValidationUtil.GraphResolution resolution;

    GraphRequest(String serviceId, String viewId, ValidationUtil.GraphType graphType, ValidationUtil.VolumeType volumeType, String from, String to, boolean raw, int wantedPointCount, ValidationUtil.GraphResolution resolution, Collection<String> servers, Collection<String> apps, Collection<String> deployments, boolean breakServers, boolean breakApps, boolean breakDeployments) {
        super(serviceId, viewId, from, to, raw, servers, apps, deployments, breakServers, breakApps, breakDeployments);
        this.graphType = graphType;
        this.volumeType = volumeType;
        this.wantedPointCount = wantedPointCount;
        this.resolution = resolution;
    }

    @Override
    public Class<GraphResult> resultClass() {
        return GraphResult.class;
    }

    @Override
    public String urlPath() {
        return this.baseUrlPath() + "/views/" + this.viewId + "/metrics/" + this.graphType.name() + "/graph";
    }

    @Override
    protected int paramsCount() {
        return super.paramsCount() + 1 + (this.volumeType != null ? 1 : 0);
    }

    @Override
    protected int fillParams(String[] params, int startIndex) throws UnsupportedEncodingException {
        int index = super.fillParams(params, startIndex);
        params[index++] = this.resolution != null ? "resolution=" + this.resolution.name() : "points=" + String.valueOf(this.wantedPointCount);
        if (this.volumeType != null) {
            params[index++] = "stats=" + this.volumeType.name();
        }
        return index;
    }

    @Override
    public String[] queryParams() throws UnsupportedEncodingException {
        return this.buildParams();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    extends BreakdownViewTimeframeRequest.Builder {
        private ValidationUtil.GraphType graphType;
        private ValidationUtil.VolumeType volumeType;
        private int wantedPointCount;
        private ValidationUtil.GraphResolution resolution;

        @Override
        public Builder setServiceId(String serviceId) {
            super.setServiceId(serviceId);
            return this;
        }

        @Override
        public Builder setViewId(String viewId) {
            super.setViewId(viewId);
            return this;
        }

        @Override
        public Builder setRaw(boolean raw) {
            super.setRaw(raw);
            return this;
        }

        public Builder setGraphType(ValidationUtil.GraphType graphType) {
            this.graphType = graphType;
            return this;
        }

        public Builder setVolumeType(ValidationUtil.VolumeType volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        @Override
        public Builder setFrom(String from) {
            super.setFrom(from);
            return this;
        }

        @Override
        public Builder setTo(String to) {
            super.setTo(to);
            return this;
        }

        @Override
        public Builder setBreakServers(boolean breakServers) {
            super.setBreakServers(breakServers);
            return this;
        }

        @Override
        public Builder setBreakApps(boolean breakApps) {
            super.setBreakApps(breakApps);
            return this;
        }

        @Override
        public Builder setBreakDeployments(boolean breakDeployments) {
            super.setBreakDeployments(breakDeployments);
            return this;
        }

        public Builder setWantedPointCount(int wantedPointCount) {
            this.wantedPointCount = wantedPointCount;
            return this;
        }

        public Builder setResolution(ValidationUtil.GraphResolution resolution) {
            this.resolution = resolution;
            return this;
        }

        @Override
        public Builder addServer(String server) {
            super.addServer(server);
            return this;
        }

        @Override
        public Builder addApp(String app) {
            super.addApp(app);
            return this;
        }

        @Override
        public Builder addDeployment(String deployment) {
            super.addDeployment(deployment);
            return this;
        }

        @Override
        public Builder setBreakFilters(Set<BreakdownType> breakdownTypes) {
            super.setBreakFilters(breakdownTypes);
            return this;
        }

        @Override
        protected void validate() {
            super.validate();
            if (this.resolution == null && this.wantedPointCount <= 0) {
                throw new IllegalArgumentException("Missing graph resolution with illegal wanted point count - " + this.wantedPointCount);
            }
            if (this.graphType == null) {
                throw new IllegalArgumentException("Missing graph type");
            }
        }

        public GraphRequest build() {
            this.validate();
            return new GraphRequest(this.serviceId, this.viewId, this.graphType, this.volumeType, this.from, this.to, this.raw, this.wantedPointCount, this.resolution, this.servers, this.apps, this.deployments, this.breakServers, this.breakApps, this.breakDeployments);
        }
    }
}

