/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.api.client.request.service;

import com.takipi.api.client.request.BaseRequest;
import com.takipi.api.client.result.service.ServicesResult;
import com.takipi.api.client.util.validation.ValidationUtil;
import com.takipi.api.core.request.intf.ApiGetRequest;
import com.takipi.common.util.StringUtil;

public class ServicesRequest
extends BaseRequest
implements ApiGetRequest<ServicesResult> {
    public final String serviceId;

    ServicesRequest(String serviceId) {
        this.serviceId = serviceId;
    }

    @Override
    public Class<ServicesResult> resultClass() {
        return ServicesResult.class;
    }

    @Override
    public String urlPath() {
        if (StringUtil.isNullOrEmpty(this.serviceId)) {
            return "/services";
        }
        return "/services/" + this.serviceId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String serviceId;

        Builder() {
        }

        public Builder setServiceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        protected void validate() {
            if (!StringUtil.isNullOrEmpty(this.serviceId) && !ValidationUtil.isLegalServiceId(this.serviceId)) {
                throw new IllegalArgumentException("Illegal service id - " + this.serviceId);
            }
        }

        public ServicesRequest build() {
            this.validate();
            return new ServicesRequest(this.serviceId);
        }
    }
}

