/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.api.client.request.settings;

import com.takipi.api.client.request.ServiceRequest;
import com.takipi.api.client.result.settings.AlertsSettingsResult;
import com.takipi.api.core.request.intf.ApiGetRequest;
import com.takipi.common.util.StringUtil;
import java.io.UnsupportedEncodingException;

public class AlertsSettingsRequest
extends ServiceRequest
implements ApiGetRequest<AlertsSettingsResult> {
    public final String email;

    protected AlertsSettingsRequest(String serviceId, String email) {
        super(serviceId);
        this.email = email;
    }

    @Override
    public Class<AlertsSettingsResult> resultClass() {
        return AlertsSettingsResult.class;
    }

    @Override
    public String urlPath() {
        return this.baseUrlPath() + "/alerts";
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public String[] queryParams() throws UnsupportedEncodingException {
        if (StringUtil.isNullOrEmpty(this.email)) {
            return null;
        }
        String[] params = new String[]{"email=" + AlertsSettingsRequest.encode(this.email)};
        return params;
    }

    public static class Builder
    extends ServiceRequest.Builder {
        private String email;

        Builder() {
        }

        @Override
        public Builder setServiceId(String serviceId) {
            super.setServiceId(serviceId);
            return this;
        }

        public Builder setEmail(String email) {
            this.email = email;
            return this;
        }

        public AlertsSettingsRequest build() {
            this.validate();
            return new AlertsSettingsRequest(this.serviceId, this.email);
        }
    }
}

