/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.api.client.request.team;

import com.google.gson.Gson;
import com.takipi.api.client.data.team.TeamMember;
import com.takipi.api.client.request.ServiceRequest;
import com.takipi.api.client.result.team.ChangeTeamMembersResult;
import com.takipi.api.client.util.validation.ValidationUtil;
import com.takipi.api.core.request.intf.ApiPostRequest;
import com.takipi.common.util.CollectionUtil;
import com.takipi.common.util.JsonUtil;
import com.takipi.common.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ChangeTeamMembersRolesRequest
extends ServiceRequest
implements ApiPostRequest<ChangeTeamMembersResult> {
    private final Map<String, ValidationUtil.UserRole> membersRoles;

    ChangeTeamMembersRolesRequest(String serviceId, Map<String, ValidationUtil.UserRole> membersRoles) {
        super(serviceId);
        this.membersRoles = membersRoles;
    }

    @Override
    public String postData() {
        ArrayList<TeamMember> teamMembers = new ArrayList<TeamMember>();
        for (Map.Entry<String, ValidationUtil.UserRole> entry : this.membersRoles.entrySet()) {
            TeamMember teamMember = new TeamMember();
            teamMember.email = entry.getKey();
            teamMember.role = entry.getValue().name();
            teamMembers.add(teamMember);
        }
        Map<String, String> map = CollectionUtil.mapOf("team_members", new Gson().toJson(teamMembers));
        return JsonUtil.createSimpleJson(map, false);
    }

    @Override
    public Class<ChangeTeamMembersResult> resultClass() {
        return ChangeTeamMembersResult.class;
    }

    @Override
    public String urlPath() {
        return this.baseUrlPath() + "/team/change-role";
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    extends ServiceRequest.Builder {
        private Map<String, ValidationUtil.UserRole> membersRoles = new HashMap<String, ValidationUtil.UserRole>();

        Builder() {
        }

        @Override
        public Builder setServiceId(String serviceId) {
            super.setServiceId(serviceId);
            return this;
        }

        public Builder addTeamMember(String email) {
            return this.addTeamMember(email, ValidationUtil.UserRole.member);
        }

        public Builder addTeamMember(String email, ValidationUtil.UserRole role) {
            if (StringUtil.isNullOrEmpty(email)) {
                throw new IllegalArgumentException("User email cannot be empty");
            }
            if (role == null) {
                throw new IllegalArgumentException("New role cannot be empty");
            }
            this.membersRoles.put(email, role);
            return this;
        }

        @Override
        protected void validate() {
            super.validate();
            if (this.membersRoles.isEmpty()) {
                throw new IllegalArgumentException("Request is empty");
            }
        }

        public ChangeTeamMembersRolesRequest build() {
            this.validate();
            return new ChangeTeamMembersRolesRequest(this.serviceId, this.membersRoles);
        }
    }
}

