/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.api.client.request.transactiontimer;

import com.takipi.api.client.request.ServiceRequest;
import com.takipi.api.client.result.EmptyResult;
import com.takipi.api.core.request.intf.ApiPostRequest;
import com.takipi.common.util.CollectionUtil;
import com.takipi.common.util.JsonUtil;
import java.util.Map;

public class EditTransactionTimerRequest
extends ServiceRequest
implements ApiPostRequest<EmptyResult> {
    private final int timerId;
    private final long threshold;

    EditTransactionTimerRequest(String serviceId, int timerId, long threshold) {
        super(serviceId);
        this.timerId = timerId;
        this.threshold = threshold;
    }

    @Override
    public String urlPath() {
        return this.baseUrlPath() + "/transaction-timers/" + Integer.toString(this.timerId);
    }

    @Override
    public String postData() {
        Map<String, String> map = CollectionUtil.mapOf("threshold", Long.toString(this.threshold));
        return JsonUtil.createSimpleJson(map, false);
    }

    @Override
    public Class<EmptyResult> resultClass() {
        return EmptyResult.class;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    extends ServiceRequest.Builder {
        private int timerId;
        private long threshold;

        Builder() {
        }

        @Override
        public Builder setServiceId(String serviceId) {
            super.setServiceId(serviceId);
            return this;
        }

        public Builder setTimerId(int timerId) {
            this.timerId = timerId;
            return this;
        }

        public Builder setThreshold(long threshold) {
            this.threshold = threshold;
            return this;
        }

        @Override
        protected void validate() {
            super.validate();
            if ((long)this.timerId <= 0L) {
                throw new IllegalArgumentException("Timer id must be positive");
            }
            if (this.threshold <= 0L) {
                throw new IllegalArgumentException("Threshold must be positive");
            }
        }

        public EditTransactionTimerRequest build() {
            this.validate();
            return new EditTransactionTimerRequest(this.serviceId, this.timerId, this.threshold);
        }
    }
}

