/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.api.client.request.view;

import com.google.gson.Gson;
import com.takipi.api.client.data.view.ViewInfo;
import com.takipi.api.client.request.ServiceRequest;
import com.takipi.api.client.result.view.CreateViewResult;
import com.takipi.api.core.request.intf.ApiPostRequest;
import com.takipi.common.util.CollectionUtil;
import com.takipi.common.util.StringUtil;

public class CreateViewRequest
extends ServiceRequest
implements ApiPostRequest<CreateViewResult> {
    private final ViewInfo viewInfo;

    CreateViewRequest(String serviceId, ViewInfo viewInfo) {
        super(serviceId);
        this.viewInfo = viewInfo;
    }

    @Override
    public String urlPath() {
        return this.baseUrlPath() + "/views";
    }

    @Override
    public String postData() {
        return new Gson().toJson((Object)this.viewInfo);
    }

    @Override
    public Class<CreateViewResult> resultClass() {
        return CreateViewResult.class;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    extends ServiceRequest.Builder {
        private ViewInfo viewInfo;

        Builder() {
        }

        @Override
        public Builder setServiceId(String serviceId) {
            super.setServiceId(serviceId);
            return this;
        }

        public Builder setViewInfo(ViewInfo viewInfo) {
            this.viewInfo = viewInfo;
            return this;
        }

        @Override
        protected void validate() {
            super.validate();
            if (this.viewInfo == null) {
                throw new IllegalArgumentException("Missing view info");
            }
            if (StringUtil.isNullOrEmpty(this.viewInfo.name)) {
                throw new IllegalArgumentException("Missing name");
            }
            if (!StringUtil.isNullOrEmpty(this.viewInfo.id)) {
                throw new IllegalArgumentException("Can't provide id for view creation");
            }
            if (this.viewInfo.filters == null) {
                throw new IllegalArgumentException("Missing filters");
            }
            if (this.viewInfo.filters.first_seen == null && CollectionUtil.safeIsEmpty(this.viewInfo.filters.labels) && CollectionUtil.safeIsEmpty(this.viewInfo.filters.event_type) && CollectionUtil.safeIsEmpty(this.viewInfo.filters.event_name) && CollectionUtil.safeIsEmpty(this.viewInfo.filters.event_location) && CollectionUtil.safeIsEmpty(this.viewInfo.filters.event_package) && CollectionUtil.safeIsEmpty(this.viewInfo.filters.entry_point) && CollectionUtil.safeIsEmpty(this.viewInfo.filters.servers) && CollectionUtil.safeIsEmpty(this.viewInfo.filters.apps) && CollectionUtil.safeIsEmpty(this.viewInfo.filters.deployments) && CollectionUtil.safeIsEmpty(this.viewInfo.filters.introduced_by) && StringUtil.isNullOrEmpty(this.viewInfo.filters.search)) {
                throw new IllegalArgumentException("Empty filters");
            }
        }

        public CreateViewRequest build() {
            this.validate();
            return new CreateViewRequest(this.serviceId, this.viewInfo);
        }
    }
}

