/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.common.util;

import java.io.Serializable;

public class Pair<T, S>
implements Serializable {
    private static final long serialVersionUID = -1362336430156481925L;
    private final T first;
    private final S second;

    public static <T, S> Pair<T, S> of(T first, S second) {
        return new Pair<T, S>(first, second);
    }

    public static <T, S> Pair<T, S> nulls() {
        return new Pair<Object, Object>(null, null);
    }

    public static <T, S> Class<Pair<T, S>> clazz() {
        return Pair.nulls().getClass();
    }

    private Pair(T first, S second) {
        this.first = first;
        this.second = second;
    }

    public T getFirst() {
        return this.first;
    }

    public S getSecond() {
        return this.second;
    }

    public String toString() {
        return "<" + this.first + ", " + this.second + ">";
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Pair)) {
            return false;
        }
        Pair other = (Pair)o;
        return Pair.nullEquals(this.first, other.first) && Pair.nullEquals(this.second, other.second);
    }

    public int hashCode() {
        int result = 0;
        if (this.first != null) {
            result ^= this.first.hashCode();
        }
        if (this.second != null) {
            result ^= this.second.hashCode();
        }
        return result;
    }

    private static boolean nullEquals(Object o1, Object o2) {
        if (o1 != null) {
            return o1.equals(o2);
        }
        return o2 == null;
    }
}

