/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.udf.input;

import com.takipi.udf.input.TimeInterval;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Input {
    private static final String COMMENT_LINE = "#";

    protected Input() {
    }

    protected Input(String raw) {
        this.initFields(raw);
    }

    protected void initFields(String raw) {
        this.reflectiveSetFields(Input.getPropertyMap(raw));
    }

    private void reflectiveSetFields(Map<String, String> properties) {
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            try {
                Field fld = this.getClass().getField(key);
                fld.setAccessible(true);
                Class<?> type = fld.getType();
                if (type == String.class) {
                    fld.set(this, value);
                    continue;
                }
                if (type == Boolean.class || type == Boolean.TYPE) {
                    fld.set(this, Input.getBoolean(value));
                    continue;
                }
                if (type == Integer.class || type == Integer.TYPE) {
                    fld.set(this, Input.getInt(value));
                    continue;
                }
                if (type == Long.class || type == Long.TYPE) {
                    fld.set(this, Input.getLong(value));
                    continue;
                }
                if (type == Double.class || type == Double.TYPE) {
                    fld.set(this, Input.getDouble(value));
                    continue;
                }
                if (type == TimeInterval.class) {
                    try {
                        fld.set(this, Input.getTimeInterval(value));
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Invalid value for " + key + " - " + value);
                    }
                }
                if (type == List.class) {
                    Type genericType = Input.getGenericType(fld);
                    if (genericType == String.class) {
                        fld.set(this, Input.getStringList(value));
                        continue;
                    }
                    throw new IllegalArgumentException("Invalid value for " + key + " - " + value);
                }
                if (type.isEnum()) {
                    boolean enumTypeFound = false;
                    for (Object enumeration : type.getEnumConstants()) {
                        if (!enumeration.toString().equals(value)) continue;
                        fld.set(this, enumeration);
                        enumTypeFound = true;
                        break;
                    }
                    if (enumTypeFound) continue;
                    throw new IllegalArgumentException("Invalid value for " + key + " - " + value);
                }
                throw new UnsupportedOperationException("No support for type - " + type);
            }
            catch (NoSuchFieldException e) {
                throw new IllegalArgumentException("No field called " + key, e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Failed setting field - " + key, e);
            }
        }
    }

    private static boolean getBoolean(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return false;
        }
        return Boolean.parseBoolean(value.trim());
    }

    private static int getInt(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return 0;
        }
        return Integer.parseInt(value.trim());
    }

    private static long getLong(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return 0L;
        }
        return Long.parseLong(value.trim());
    }

    private static double getDouble(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return 0.0;
        }
        return Double.parseDouble(value.trim());
    }

    private static TimeInterval getTimeInterval(String value) {
        return TimeInterval.parse(value.trim());
    }

    private static List<String> getStringList(String value) {
        if (value == null || value.isEmpty()) {
            return Collections.emptyList();
        }
        String[] split = value.split(";");
        ArrayList<String> result = new ArrayList<String>(split.length);
        Collections.addAll(result, split);
        return result;
    }

    private static Type getGenericType(Field fld) {
        Type[] genericTypes = Input.getGenericTypes(fld);
        if (genericTypes == null) {
            return null;
        }
        return genericTypes[0];
    }

    private static Type[] getGenericTypes(Field fld) {
        Type type = fld.getGenericType();
        if (type instanceof ParameterizedType) {
            ParameterizedType genericType = (ParameterizedType)type;
            return genericType.getActualTypeArguments();
        }
        return null;
    }

    private static Map<String, String> getPropertyMap(String rawInput) {
        String[] lines;
        HashMap<String, String> result = new HashMap<String, String>();
        for (String line : lines = rawInput.split("\\r?\\n")) {
            String actualLine = StringUtils.trimToEmpty((String)line);
            if (actualLine.startsWith(COMMENT_LINE) || actualLine.isEmpty()) continue;
            int index = actualLine.indexOf(61);
            if (index <= 0 || index > actualLine.length() - 1) {
                throw new IllegalArgumentException("Invalid input line - " + actualLine);
            }
            String key = StringUtils.trim((String)actualLine.substring(0, index));
            String value = StringUtils.trim((String)actualLine.substring(index + 1, actualLine.length()));
            if (key.isEmpty()) {
                throw new IllegalArgumentException("Invalid input line - " + actualLine);
            }
            result.put(key, value);
        }
        return result;
    }
}

