/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.udf.input;

public class TimeInterval {
    private static final int M_TO_H = 60;
    private static final int M_TO_D = 1440;
    private static final int M_TO_W = 10080;
    private final String raw;
    private final int minutes;

    private TimeInterval(String raw, int minutes) {
        this.raw = raw;
        this.minutes = minutes;
    }

    public int asMinutes() {
        return this.minutes;
    }

    public int asHours() {
        return this.minutes / 60;
    }

    public int asDays() {
        return this.minutes / 1440;
    }

    public int asWeeks() {
        return this.minutes / 10080;
    }

    public boolean isPositive() {
        return this.minutes > 0;
    }

    public boolean isZero() {
        return this.minutes == 0;
    }

    public boolean isNegative() {
        return this.minutes < 0;
    }

    public String toString() {
        return this.raw;
    }

    private static TimeInterval of(String raw, int minutes) {
        return new TimeInterval(raw, minutes);
    }

    public static TimeInterval of(int minutes) {
        return new TimeInterval(minutes + "m", minutes);
    }

    public static TimeInterval parse(String s) {
        if (s == null || s.isEmpty()) {
            return TimeInterval.of(0);
        }
        char timeUnit = s.charAt(s.length() - 1);
        String timeWindow = s.substring(0, s.length() - 1);
        switch (timeUnit) {
            case 'w': {
                return TimeInterval.of(s, Integer.valueOf(timeWindow) * 10080);
            }
            case 'd': {
                return TimeInterval.of(s, Integer.valueOf(timeWindow) * 1440);
            }
            case 'h': {
                return TimeInterval.of(s, Integer.valueOf(timeWindow) * 60);
            }
            case 'm': {
                return TimeInterval.of(s, Integer.valueOf(timeWindow));
            }
        }
        return TimeInterval.of(Integer.valueOf(s));
    }
}

