/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.udf.app;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.takipi.api.client.ApiClient;
import com.takipi.api.client.data.category.Category;
import com.takipi.api.client.data.view.ViewFilters;
import com.takipi.api.client.data.view.ViewInfo;
import com.takipi.api.client.util.category.CategoryUtil;
import com.takipi.api.client.util.client.ClientUtil;
import com.takipi.api.client.util.view.ViewUtil;
import com.takipi.common.util.CollectionUtil;
import com.takipi.udf.ContextArgs;
import com.takipi.udf.input.Input;
import com.takipi.udf.util.TestUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class AppRoutingFunction {
    private static final boolean SHARED = true;
    private static final boolean IMMUTABLE_VIEWS = true;

    public static String validateInput(String rawInput) {
        return AppRoutingFunction.parseAppRoutingInput(rawInput).toString();
    }

    static AppRoutingInput parseAppRoutingInput(String rawInput) {
        AppRoutingInput input;
        System.out.println("validateInput rawInput: " + rawInput);
        if (Strings.isNullOrEmpty((String)rawInput)) {
            throw new IllegalArgumentException("Input is empty");
        }
        try {
            input = AppRoutingInput.of(rawInput);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        if (input.category_name == null) {
            throw new IllegalArgumentException("'category_name' must exist");
        }
        if (input.max_views <= 0) {
            throw new IllegalArgumentException("'max_views' must be greater than zero");
        }
        return input;
    }

    public static void execute(String rawContextArgs, String rawInput) {
        System.out.println("execute: " + rawContextArgs);
        ContextArgs args = (ContextArgs)new Gson().fromJson(rawContextArgs, ContextArgs.class);
        if (!args.viewValidate()) {
            throw new IllegalArgumentException("Invalid context args - " + rawContextArgs);
        }
        AppRoutingInput input = AppRoutingFunction.parseAppRoutingInput(rawInput);
        AppRoutingFunction.buildAppRoutingViews(args, input);
    }

    private static void buildAppRoutingViews(ContextArgs args, AppRoutingInput input) {
        String serviceId;
        ApiClient apiClient = args.apiClient();
        List apps = ClientUtil.getApplications((ApiClient)apiClient, (String)(serviceId = args.serviceId), (boolean)true);
        if (CollectionUtil.safeIsEmpty((Collection)apps)) {
            System.out.println("Could not acquire apps for service " + serviceId);
            return;
        }
        Map views = ViewUtil.getServiceViewsByName((ApiClient)apiClient, (String)serviceId);
        if (CollectionUtil.safeIsEmpty((Map)views)) {
            System.out.println("Could not acquire view for service " + serviceId);
            return;
        }
        String categoryId = AppRoutingFunction.createAppCategory(apiClient, serviceId, input);
        int appsWithViewsSize = 0;
        HashSet appsWithoutViews = Sets.newHashSet();
        for (String app : apps) {
            if (!views.containsKey(app)) {
                appsWithoutViews.add(app);
                continue;
            }
            ++appsWithViewsSize;
        }
        if (appsWithViewsSize >= input.max_views) {
            System.out.println("Found " + appsWithViewsSize + " app views, exceeding max for " + serviceId);
            return;
        }
        ArrayList viewInfos = Lists.newArrayList();
        for (String app : appsWithoutViews) {
            ViewInfo viewInfo = new ViewInfo();
            viewInfo.name = app;
            viewInfo.filters = new ViewFilters();
            viewInfo.filters.apps = Collections.singletonList(app);
            viewInfo.shared = true;
            viewInfo.immutable = true;
            viewInfos.add(viewInfo);
        }
        ViewUtil.createFilteredViews((ApiClient)apiClient, (String)serviceId, (Collection)viewInfos, (Map)views, (String)categoryId);
    }

    private static String createAppCategory(ApiClient apiClient, String serviceId, AppRoutingInput input) {
        String result;
        Category category = CategoryUtil.getServiceCategoryByName((ApiClient)apiClient, (String)serviceId, (String)input.category_name);
        if (category == null) {
            result = CategoryUtil.createCategory((String)input.category_name, (String)serviceId, (ApiClient)apiClient, (boolean)true);
            System.out.println("Created category " + result + " for " + input.category_name);
        } else {
            result = category.id;
        }
        return result;
    }

    public static void main(String[] args) {
        String rawContextArgs = TestUtil.getViewContextArgs((String[])args, (String)"All Events");
        CharSequence[] sampleValues = new String[]{"category_name=Apps", "max_views=50"};
        AppRoutingFunction.execute(rawContextArgs, String.join((CharSequence)"\n", sampleValues));
    }

    static class AppRoutingInput
    extends Input {
        public String category_name;
        public int max_views;

        private AppRoutingInput(String raw) {
            super(raw);
        }

        static AppRoutingInput of(String raw) {
            return new AppRoutingInput(raw);
        }

        public String toString() {
            return "AppRouting: " + this.category_name + " " + this.max_views;
        }
    }
}

