/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.udf.deployment;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.takipi.api.client.ApiClient;
import com.takipi.api.client.data.category.Category;
import com.takipi.api.client.data.deployment.SummarizedDeployment;
import com.takipi.api.client.data.view.SummarizedView;
import com.takipi.api.client.data.view.ViewFilters;
import com.takipi.api.client.data.view.ViewInfo;
import com.takipi.api.client.util.category.CategoryUtil;
import com.takipi.api.client.util.client.ClientUtil;
import com.takipi.api.client.util.view.ViewUtil;
import com.takipi.common.util.CollectionUtil;
import com.takipi.udf.ContextArgs;
import com.takipi.udf.input.Input;
import com.takipi.udf.util.TestUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;

public class DeploymentRoutingFunction {
    private static final boolean SHARED = true;
    private static final boolean IMMUTABLE_VIEWS = true;

    public static String validateInput(String rawInput) {
        return DeploymentRoutingFunction.parseDeploymentRoutingInput(rawInput).toString();
    }

    static DeploymentRoutingInput parseDeploymentRoutingInput(String rawInput) {
        DeploymentRoutingInput input;
        System.out.println("validateInput rawInput: " + rawInput);
        if (Strings.isNullOrEmpty((String)rawInput)) {
            throw new IllegalArgumentException("Input is empty");
        }
        try {
            input = DeploymentRoutingInput.of(rawInput);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        if (input.category_name == null) {
            throw new IllegalArgumentException("'category_name' must exist");
        }
        if (input.max_views <= 0) {
            throw new IllegalArgumentException("'max_views' must be greater than zero");
        }
        return input;
    }

    public static void execute(String rawContextArgs, String rawInput) {
        System.out.println("execute: " + rawContextArgs);
        ContextArgs args = (ContextArgs)new Gson().fromJson(rawContextArgs, ContextArgs.class);
        if (!args.viewValidate()) {
            throw new IllegalArgumentException("Invalid context args - " + rawContextArgs);
        }
        DeploymentRoutingInput input = DeploymentRoutingFunction.parseDeploymentRoutingInput(rawInput);
        DeploymentRoutingFunction.buildDeploymentRoutingViews(args, input);
    }

    private static String cleanPrefix(DeploymentRoutingInput input) {
        return input.prefix.replace("'", "");
    }

    private static void buildDeploymentRoutingViews(ContextArgs args, DeploymentRoutingInput input) {
        ApiClient apiClient = args.apiClient();
        String serviceId = args.serviceId;
        int maxViews = input.max_views;
        Collection deployments = ClientUtil.getSummarizedDeployments((ApiClient)apiClient, (String)serviceId, (boolean)false);
        if (CollectionUtil.safeIsEmpty((Collection)deployments)) {
            System.err.println("Could not acquire all deployments of service " + serviceId);
            return;
        }
        Map views = ViewUtil.getServiceViewsByName((ApiClient)apiClient, (String)serviceId);
        if (CollectionUtil.safeIsEmpty((Map)views)) {
            System.err.println("Could not acquire views of service " + serviceId);
            return;
        }
        List sortedDeployments = deployments.parallelStream().sorted((dep1, dep2) -> ISODateTimeFormat.dateTimeParser().parseDateTime(dep2.last_seen).compareTo((ReadableInstant)ISODateTimeFormat.dateTimeParser().parseDateTime(dep1.last_seen))).collect(Collectors.toList());
        maxViews = Math.min(maxViews, sortedDeployments.size());
        for (Object deployment : sortedDeployments.subList(maxViews, sortedDeployments.size())) {
            SummarizedView deploymentView = (SummarizedView)views.get(DeploymentRoutingFunction.toViewName(input, ((SummarizedDeployment)deployment).name));
            if (deploymentView == null) continue;
            System.out.println("Removing view " + deploymentView.id + " for deployment " + ((SummarizedDeployment)deployment).name);
            ViewUtil.removeView((ApiClient)apiClient, (String)serviceId, (String)deploymentView.id);
        }
        ArrayList newDeploymentViewsInfo = Lists.newArrayList();
        for (SummarizedDeployment deployment : sortedDeployments.subList(0, maxViews)) {
            String deploymentName = deployment.name;
            SummarizedView deploymentView = (SummarizedView)views.get(DeploymentRoutingFunction.toViewName(input, deployment.name));
            if (deploymentView != null) {
                System.out.println("View " + deploymentView.id + " already exists for deployment " + deploymentName);
                continue;
            }
            System.out.println("Queueing view creation for deployment " + deploymentName);
            ViewInfo viewInfo = new ViewInfo();
            viewInfo.name = DeploymentRoutingFunction.toViewName(input, deploymentName);
            viewInfo.filters = new ViewFilters();
            viewInfo.filters.introduced_by = Collections.singletonList(deploymentName);
            viewInfo.shared = true;
            viewInfo.immutable = true;
            newDeploymentViewsInfo.add(viewInfo);
        }
        if (CollectionUtil.safeIsEmpty((Collection)newDeploymentViewsInfo)) {
            return;
        }
        String categoryId = DeploymentRoutingFunction.createDepCategory(apiClient, serviceId, input);
        ViewUtil.createFilteredViews((ApiClient)apiClient, (String)serviceId, (Collection)newDeploymentViewsInfo, (Map)views, (String)categoryId);
    }

    private static String toViewName(DeploymentRoutingInput input, String dep) {
        String result = input.prefix != null ? DeploymentRoutingFunction.cleanPrefix(input) + dep : dep;
        return result;
    }

    private static String createDepCategory(ApiClient apiClient, String serviceId, DeploymentRoutingInput input) {
        String result;
        Category category = CategoryUtil.getServiceCategoryByName((ApiClient)apiClient, (String)serviceId, (String)input.category_name);
        if (category == null) {
            result = CategoryUtil.createCategory((String)input.category_name, (String)serviceId, (ApiClient)apiClient, (boolean)true);
            System.out.println("Created category " + result + " for " + input.category_name);
        } else {
            result = category.id;
        }
        return result;
    }

    public static void main(String[] args) {
        String rawContextArgs = TestUtil.getViewContextArgs((String[])args, (String)"All Events");
        CharSequence[] sampleValues = new String[]{"category_name=CI / CD", "prefix='New'' in '", "max_views=4"};
        DeploymentRoutingFunction.execute(rawContextArgs, String.join((CharSequence)"\n", sampleValues));
    }

    static class DeploymentRoutingInput
    extends Input {
        public String category_name;
        public int max_views;
        public String prefix;

        private DeploymentRoutingInput(String raw) {
            super(raw);
        }

        static DeploymentRoutingInput of(String raw) {
            return new DeploymentRoutingInput(raw);
        }

        public String toString() {
            return "DeploymentRouting: " + this.category_name + " " + this.max_views;
        }
    }
}

