/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.udf.infra;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.takipi.api.client.ApiClient;
import com.takipi.api.client.request.event.EventsRequest;
import com.takipi.api.client.request.label.BatchModifyLabelsRequest;
import com.takipi.api.client.result.event.EventResult;
import com.takipi.api.client.result.event.EventsResult;
import com.takipi.api.client.util.category.CategoryUtil;
import com.takipi.api.client.util.infra.Categories;
import com.takipi.api.client.util.infra.InfraUtil;
import com.takipi.api.client.util.settings.ServiceSettingsData;
import com.takipi.api.client.util.settings.SettingsUtil;
import com.takipi.api.core.request.intf.ApiGetRequest;
import com.takipi.api.core.request.intf.ApiPostRequest;
import com.takipi.api.core.url.UrlClient;
import com.takipi.common.util.CollectionUtil;
import com.takipi.common.util.Pair;
import com.takipi.udf.ContextArgs;
import com.takipi.udf.input.Input;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class RoutingFunction {
    static RoutingInput getRoutingInput(String rawInput) {
        RoutingInput input;
        System.out.println("validateInput rawInput:" + rawInput);
        if (Strings.isNullOrEmpty((String)rawInput)) {
            throw new IllegalArgumentException("Input is empty");
        }
        try {
            input = RoutingInput.of(rawInput);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        if (StringUtils.isEmpty((CharSequence)input.category_name)) {
            throw new IllegalArgumentException("'category_name' can't be empty");
        }
        return input;
    }

    static void install(String rawContextArgs, RoutingInput input) {
        ContextArgs args = (ContextArgs)new Gson().fromJson(rawContextArgs, ContextArgs.class);
        System.out.println("install context: " + rawContextArgs);
        if (!args.validate()) {
            throw new IllegalArgumentException("Bad context args - " + rawContextArgs);
        }
        if (!args.viewValidate()) {
            return;
        }
        ApiClient apiClient = args.apiClient();
        DateTime to = DateTime.now();
        DateTime from = to.minusDays(30);
        DateTimeFormatter fmt = ISODateTimeFormat.dateTime().withZoneUTC();
        boolean includeStacktrace = input.routing_type == Categories.CategoryType.app;
        EventsRequest eventsRequest = EventsRequest.newBuilder().setServiceId(args.serviceId).setViewId(args.viewId).setIncludeStacktrace(includeStacktrace).setFrom(from.toString(fmt)).setTo(to.toString(fmt)).build();
        UrlClient.Response eventsResponse = apiClient.get((ApiGetRequest)eventsRequest);
        if (eventsResponse.isBadResponse()) {
            throw new IllegalStateException("Failed getting view events.");
        }
        EventsResult eventsResult = (EventsResult)eventsResponse.data;
        if (CollectionUtil.safeIsEmpty((Collection)eventsResult.events)) {
            return;
        }
        String categoryId = CategoryUtil.createCategory((String)input.category_name, (String)args.serviceId, (ApiClient)apiClient);
        Map<Categories.CategoryType, String> categoryIds = Collections.singletonMap(input.routing_type, categoryId);
        Categories categories = RoutingFunction.getCategories(apiClient, args.serviceId, input);
        HashSet createdLabels = Sets.newHashSet();
        boolean hasModifications = false;
        BatchModifyLabelsRequest.Builder builder = BatchModifyLabelsRequest.newBuilder().setServiceId(args.serviceId).setHandleSimilarEvents(input.handleSimilarEvents());
        for (EventResult event : eventsResult.events) {
            Pair eventCategories = InfraUtil.categorizeEvent((EventResult)event, (String)args.serviceId, categoryIds, (Categories)categories, (Set)createdLabels, (ApiClient)apiClient, (boolean)false, (boolean)false);
            Collection labelsToAdd = (Collection)eventCategories.getFirst();
            Collection labelsToRemove = (Collection)eventCategories.getSecond();
            if (labelsToAdd.isEmpty() && labelsToRemove.isEmpty()) continue;
            builder.addLabelModifications(event.id, labelsToAdd, labelsToRemove);
            hasModifications = true;
        }
        if (!hasModifications) {
            return;
        }
        UrlClient.Response response = apiClient.post((ApiPostRequest)builder.build());
        if (response.isBadResponse()) {
            throw new IllegalStateException("Failed batch apply of labels.");
        }
    }

    static void execute(String rawContextArgs, RoutingInput input) {
        ContextArgs args = (ContextArgs)new Gson().fromJson(rawContextArgs, ContextArgs.class);
        System.out.println("execute context: " + rawContextArgs);
        if (!args.validate()) {
            throw new IllegalArgumentException("Bad context args - " + rawContextArgs);
        }
        if (!args.eventValidate()) {
            return;
        }
        ApiClient apiClient = args.apiClient();
        String categoryId = CategoryUtil.createCategory((String)input.category_name, (String)args.serviceId, (ApiClient)apiClient);
        Map<Categories.CategoryType, String> categoryIds = Collections.singletonMap(input.routing_type, categoryId);
        Categories categories = RoutingFunction.getCategories(apiClient, args.serviceId, input);
        InfraUtil.categorizeEvent((String)args.eventId, (String)args.serviceId, categoryIds, (Categories)categories, (Set)Sets.newHashSet(), (ApiClient)apiClient, (boolean)true, (boolean)input.handleSimilarEvents());
    }

    private static Categories getCategories(ApiClient apiClient, String serviceId, RoutingInput input) {
        ServiceSettingsData settings;
        ArrayList categories = Lists.newArrayList();
        if (!CollectionUtil.safeIsEmpty(input.getCategories())) {
            categories.addAll(input.getCategories());
        }
        if ((settings = SettingsUtil.getServiceReliabilitySettings((ApiClient)apiClient, (String)serviceId)) != null && !CollectionUtil.safeIsEmpty((Collection)settings.tiers)) {
            Categories.fillMissingCategoryNames((Collection)settings.tiers);
            categories.addAll(settings.tiers);
        }
        return Categories.expandWithDefaultCategories((Collection)categories);
    }

    static class RoutingInput
    extends Input {
        public List<String> namespaces;
        public String template_view;
        public String category_name;
        public Categories.CategoryType routing_type;
        private final List<Categories.Category> categories;

        RoutingInput(String raw) {
            super(raw);
            if (this.routing_type == null) {
                this.routing_type = Categories.CategoryType.infra;
            }
            this.categories = this.processNamespaces();
        }

        public List<Categories.Category> getCategories() {
            return this.categories;
        }

        public boolean handleSimilarEvents() {
            return this.routing_type != Categories.CategoryType.app;
        }

        private List<Categories.Category> processNamespaces() {
            if (CollectionUtil.safeIsEmpty(this.namespaces)) {
                return Collections.emptyList();
            }
            ArrayList result = Lists.newArrayList();
            for (String namespace : this.namespaces) {
                int index = namespace.indexOf(61);
                if (index <= 0 || index > namespace.length() - 1) {
                    throw new IllegalArgumentException("Invalid namespaces");
                }
                String key = StringUtils.trim((String)namespace.substring(0, index));
                String value = StringUtils.trim((String)namespace.substring(index + 1, namespace.length()));
                if (key.isEmpty() || value.isEmpty()) {
                    throw new IllegalArgumentException("Invalid namespaces");
                }
                Categories.Category category = new Categories.Category();
                category.names = Collections.singletonList(key);
                category.labels = Collections.singletonList(value);
                category.type = this.routing_type;
                result.add(category);
            }
            return result;
        }

        static RoutingInput of(String raw) {
            return new RoutingInput(raw);
        }
    }
}

