/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.udf.jira;

import com.atlassian.jira.rest.client.JiraRestClient;
import com.atlassian.jira.rest.client.domain.Issue;
import com.atlassian.jira.rest.client.domain.SearchResult;
import com.takipi.api.client.request.label.BatchModifyLabelsRequest;
import com.takipi.api.client.result.event.EventResult;
import com.takipi.api.core.request.intf.ApiPostRequest;
import com.takipi.udf.ContextArgs;
import com.takipi.udf.jira.JiraEvent;
import com.takipi.udf.jira.JiraIntegrationFunction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import org.apache.commons.lang3.StringUtils;

public class JiraEventList {
    private HashMap<String, JiraEvent> eventList = new HashMap(1000);
    private JiraIntegrationFunction.JiraIntegrationInput input;
    private ContextArgs args;

    public JiraEventList(JiraIntegrationFunction.JiraIntegrationInput input, ContextArgs args) {
        this.input = input;
        this.args = args;
    }

    public void addEvent(String issueId, EventResult event) {
        if (this.eventList.size() >= 1000) {
            if (this.input.debug) {
                System.out.println("reached max Jira issues (1000)");
            }
            return;
        }
        if (this.eventList.containsKey(issueId)) {
            this.eventList.get((Object)issueId).events.add(event);
        } else {
            JiraEvent jiraEvent = new JiraEvent(event);
            this.eventList.put(issueId, jiraEvent);
        }
    }

    public HashMap<String, JiraEvent> getEventList() {
        return this.eventList;
    }

    public void sync(JiraRestClient client) {
        this.populate(client);
        this.syncBatch();
    }

    private void populate(JiraRestClient client) {
        if (this.eventList.size() < 1) {
            if (this.input.debug) {
                System.out.println("Event list is empty.");
            }
            return;
        }
        StringBuilder updateKeys = new StringBuilder("issuekey in (");
        for (String key2 : this.eventList.keySet()) {
            updateKeys.append(key2);
            updateKeys.append(", ");
        }
        String updateKeysStr = updateKeys.toString();
        updateKeysStr = updateKeys.substring(0, updateKeys.length() - 2) + ")";
        SearchResult updateKeysResult = (SearchResult)client.getSearchClient().searchJql(updateKeysStr, 1000, 0).claim();
        HashSet<String> keys = new HashSet<String>();
        keys.addAll(this.eventList.keySet());
        updateKeysResult.getIssues().forEach(issue -> {
            String key = issue.getKey();
            keys.remove(key);
        });
        if (!keys.isEmpty()) {
            HashMap tempList = new HashMap(keys.size());
            keys.forEach(key -> {
                Issue issue = (Issue)client.getIssueClient().getIssue(key).claim();
                String issueKey = issue.getKey();
                JiraEvent event = this.eventList.get(key);
                tempList.put(issueKey, event);
            });
            this.eventList.keySet().removeAll(keys);
            this.eventList.putAll(tempList);
        }
        if (this.input.debug) {
            System.out.println(">>> eventList: ");
            System.out.println(this.eventList);
        }
        HashSet<String> unknownKeys = new HashSet<String>();
        unknownKeys.addAll(this.eventList.keySet());
        if (!StringUtils.isEmpty((CharSequence)this.input.hiddenStatus)) {
            if (this.input.debug) {
                System.out.println(">>> Syncing Hidden / Jira " + this.input.resolutionOrStatus + " = " + this.input.hiddenStatus);
            }
            StringBuilder jqlHidden = new StringBuilder(this.input.resolutionOrStatus);
            jqlHidden.append(" = \"");
            jqlHidden.append(this.input.hiddenStatus);
            jqlHidden.append("\" AND issuekey in (");
            for (String key3 : this.eventList.keySet()) {
                jqlHidden.append(key3);
                jqlHidden.append(", ");
            }
            Object jqlHiddenStr = jqlHidden.toString();
            jqlHiddenStr = ((String)jqlHiddenStr).substring(0, ((String)jqlHiddenStr).length() - 2) + ")";
            if (this.input.debug) {
                System.out.println(">>> jql hidden: ");
                System.out.println((String)jqlHiddenStr);
            }
            SearchResult hidden = (SearchResult)client.getSearchClient().searchJql((String)jqlHiddenStr, 1000, 0).claim();
            hidden.getIssues().forEach(basicIssue -> {
                String key = basicIssue.getKey();
                this.eventList.get((Object)key).issueStatus = JiraEvent.Status.HIDDEN;
                unknownKeys.remove(key);
            });
        } else if (this.input.debug) {
            System.out.println(">>> Skipping Hidden");
        }
        if (unknownKeys.size() < 1) {
            if (this.input.debug) {
                System.out.println(">>> No issues remain");
            }
            return;
        }
        if (!StringUtils.isEmpty((CharSequence)this.input.resolvedStatus)) {
            if (this.input.debug) {
                System.out.println(">>> Syncing Resolved / Jira " + this.input.resolutionOrStatus + " = " + this.input.resolvedStatus);
            }
            StringBuilder jqlResolved = new StringBuilder(this.input.resolutionOrStatus);
            jqlResolved.append(" = \"");
            jqlResolved.append(this.input.resolvedStatus);
            jqlResolved.append("\" AND issuekey in (");
            for (String key3 : unknownKeys) {
                jqlResolved.append(key3);
                jqlResolved.append(", ");
            }
            String jqlResolvedStr = jqlResolved.toString();
            jqlResolvedStr = jqlResolvedStr.substring(0, jqlResolvedStr.length() - 2) + ")";
            if (this.input.debug) {
                System.out.println(">>> jql resolved: ");
                System.out.println(jqlResolvedStr);
            }
            SearchResult resolved = (SearchResult)client.getSearchClient().searchJql(jqlResolvedStr, 1000, 0).claim();
            resolved.getIssues().forEach(basicIssue -> {
                String key = basicIssue.getKey();
                this.eventList.get((Object)key).issueStatus = JiraEvent.Status.RESOLVED;
            });
        } else if (this.input.debug) {
            System.out.println(">>> Skipping Resolved");
        }
    }

    private void syncBatch() {
        block3: {
            BatchModifyLabelsRequest.Builder batchBuilder = BatchModifyLabelsRequest.newBuilder().setServiceId(this.args.serviceId);
            if (this.input.debug) {
                System.out.println("syncing " + this.eventList.size() + " issues");
            }
            this.eventList.forEach((issueId, jiraEvent) -> jiraEvent.events.forEach(eventResult -> {
                JiraEvent.Status eventStatus = JiraEvent.status(eventResult);
                if (jiraEvent.issueStatus != eventStatus) {
                    if (this.input.debug) {
                        System.out.println(">>> update event! (" + eventResult.id + ") issueStatus: " + (Object)((Object)jiraEvent.issueStatus) + " eventStatus: " + (Object)((Object)eventStatus));
                    }
                    LinkedList<String> addLabels = new LinkedList<String>();
                    addLabels.add(jiraEvent.issueStatus.getLabel());
                    ArrayList<String> removeLabels = new ArrayList<String>();
                    removeLabels.add(eventStatus.getLabel());
                    batchBuilder.addLabelModifications(eventResult.id, addLabels, removeLabels);
                }
            }));
            try {
                this.args.apiClient().post((ApiPostRequest)batchBuilder.setHandleSimilarEvents(false).build());
            }
            catch (IllegalArgumentException ex) {
                if (!this.input.debug) break block3;
                System.out.println(ex.getMessage());
            }
        }
    }

    public String toString() {
        return "{ eventList='" + this.getEventList() + "'}\n";
    }
}

