/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.udf.jira;

import com.atlassian.jira.rest.client.JiraRestClient;
import com.atlassian.jira.rest.client.internal.async.AsynchronousJiraRestClientFactory;
import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.takipi.api.client.ApiClient;
import com.takipi.api.client.request.event.EventsRequest;
import com.takipi.api.client.result.event.EventResult;
import com.takipi.api.client.result.event.EventsResult;
import com.takipi.api.core.request.intf.ApiGetRequest;
import com.takipi.api.core.url.UrlClient;
import com.takipi.common.util.CollectionUtil;
import com.takipi.udf.ContextArgs;
import com.takipi.udf.input.Input;
import com.takipi.udf.jira.JiraEventList;
import com.takipi.udf.util.TestUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class JiraIntegrationFunction {
    public static String validateInput(String rawInput) {
        JiraIntegrationInput input = JiraIntegrationFunction.getJiraIntegrationInput(rawInput);
        if (!input.resolutionOrStatus.equals("resolution") && !input.resolutionOrStatus.equals("status")) {
            throw new IllegalArgumentException("'resolutionOrStatus' must be 'resolution' or 'status'");
        }
        if (StringUtils.isEmpty((CharSequence)input.resolvedStatus) && StringUtils.isEmpty((CharSequence)input.hiddenStatus)) {
            throw new IllegalArgumentException("'resolvedStatus' or 'hiddenStatus' is required");
        }
        AsynchronousJiraRestClientFactory factory = new AsynchronousJiraRestClientFactory();
        try {
            URI uri = new URI(input.jiraURL);
            JiraRestClient client = factory.createWithBasicHttpAuthentication(uri, input.jiraUsername, input.jiraToken);
            if (!StringUtils.isEmpty((CharSequence)input.resolvedStatus)) {
                client.getSearchClient().searchJql(input.resolutionOrStatus + " = \"" + input.resolvedStatus + "\"", 1, 0).claim();
                if (input.debug) {
                    System.out.println(">> verified input.resolveStatus");
                }
            }
            if (!StringUtils.isEmpty((CharSequence)input.hiddenStatus)) {
                client.getSearchClient().searchJql(input.resolutionOrStatus + " = \"" + input.hiddenStatus + "\"", 1, 0).claim();
                if (input.debug) {
                    System.out.println(">> verified input.hiddenStatus");
                }
            }
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid URL. Check jiraURL and try again");
        }
        catch (Exception e) {
            if (e.getMessage().contains("AUTHENTICATED_FAILED")) {
                throw new IllegalArgumentException("Authentication failed.");
            }
            if (e.getMessage().contains("AUTHENTICATION_DENIED")) {
                throw new IllegalArgumentException("Authentication denied. Please disable Jira CAPTCHA challenge.");
            }
            if (input.debug) {
                System.out.println("---- JIRA UDF VALIDATION EXCEPTION: ----");
                System.out.println(e.getMessage());
                System.out.println("----------------------------------------");
            }
            throw new IllegalArgumentException(e.getMessage());
        }
        return input.toString();
    }

    static JiraIntegrationInput getJiraIntegrationInput(String rawInput) {
        JiraIntegrationInput input;
        if (Strings.isNullOrEmpty((String)rawInput)) {
            throw new IllegalArgumentException("Input is empty");
        }
        try {
            input = JiraIntegrationInput.of(rawInput);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        if (input.days <= 0) {
            throw new IllegalArgumentException("'days' must be at least 1 day");
        }
        if (StringUtils.isEmpty((CharSequence)input.jiraURL)) {
            throw new IllegalArgumentException("'jiraURL' is required");
        }
        if (StringUtils.isEmpty((CharSequence)input.jiraUsername)) {
            throw new IllegalArgumentException("'jiraUsername' is required");
        }
        if (StringUtils.isEmpty((CharSequence)input.jiraToken)) {
            throw new IllegalArgumentException("'jiraToken' is required");
        }
        return input;
    }

    public static void execute(String rawContextArgs, String rawInput) {
        JiraIntegrationInput input = JiraIntegrationFunction.getJiraIntegrationInput(rawInput);
        ContextArgs args = (ContextArgs)new Gson().fromJson(rawContextArgs, ContextArgs.class);
        if (!args.validate()) {
            throw new IllegalArgumentException("Bad context args: " + rawContextArgs);
        }
        if (input.debug) {
            System.out.println(String.format("Logging in to %s with username '%s'", input.jiraURL, input.jiraUsername));
        }
        AsynchronousJiraRestClientFactory factory = new AsynchronousJiraRestClientFactory();
        try {
            URI uri = new URI(input.jiraURL);
            JiraRestClient client = factory.createWithBasicHttpAuthentication(uri, input.jiraUsername, input.jiraToken);
            JiraEventList jiraEvents = JiraIntegrationFunction.fetchJiraEvents(args, input);
            jiraEvents.sync(client);
        }
        catch (URISyntaxException e) {
            if (input.debug) {
                System.out.println("Caught URISyntaxException. Check jiraURL and try again.");
                System.out.println(e.getMessage());
            }
            System.exit(1);
        }
        catch (Exception e) {
            if (input.debug) {
                System.out.println("Caught Exception from Jira Client.");
                System.out.println(e.getMessage());
            }
            System.exit(1);
        }
        System.exit(0);
    }

    private static JiraEventList fetchJiraEvents(ContextArgs args, JiraIntegrationInput input) {
        EventsRequest eventsRequest;
        UrlClient.Response eventsResponse;
        ApiClient apiClient = args.apiClient();
        Instant to = Instant.now();
        Instant from = to.minus(input.days, ChronoUnit.DAYS);
        if (input.debug) {
            System.out.println("to: " + to);
            System.out.println("from: " + from);
            System.out.println("view id: " + args.viewId);
        }
        if ((eventsResponse = apiClient.get((ApiGetRequest)(eventsRequest = EventsRequest.newBuilder().setServiceId(args.serviceId).setViewId(args.viewId).setFrom(from.toString()).setTo(to.toString()).build()))).isBadResponse()) {
            if (input.debug) {
                System.out.println("Failed getting events");
            }
            throw new IllegalStateException("Failed getting events.");
        }
        EventsResult eventsResult = (EventsResult)eventsResponse.data;
        JiraEventList eventList = new JiraEventList(input, args);
        if (CollectionUtil.safeIsEmpty((Collection)eventsResult.events)) {
            if (input.debug) {
                System.out.println("Found no events from the last " + input.days + " days.");
            }
            return eventList;
        }
        List events = eventsResult.events;
        for (EventResult event : events) {
            if (event.jira_issue_url == null) continue;
            String issueId = JiraIntegrationFunction.getJiraIssueId(event.jira_issue_url);
            eventList.addEvent(issueId, event);
        }
        return eventList;
    }

    private static String getJiraIssueId(String jiraURL) {
        int index = jiraURL.lastIndexOf("/") + 1;
        return jiraURL.substring(index);
    }

    public static void main(String[] args) {
        Instant start = Instant.now();
        if (args == null || args.length < 10) {
            throw new IllegalArgumentException("java JiraIntegrationFunction API_URL API_KEY SERVICE_ID JIRA_URL JIRA_USER JIRA_PASS DAYS RESOLVED_STATUS HIDDEN_STATUS VIEW_NAME");
        }
        String rawContextArgs = TestUtil.getViewContextArgs((String[])args, (String)args[9]);
        CharSequence[] sampleValues = new String[]{"jiraURL=" + args[3], "jiraUsername=" + args[4], "jiraToken=" + args[5], "days=" + args[6], "resolvedStatus=" + args[7], "hiddenStatus=" + args[8]};
        try {
            JiraIntegrationFunction.execute(rawContextArgs, String.join((CharSequence)"\n", sampleValues));
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        Instant finish = Instant.now();
        long timeElapsed = Duration.between(start, finish).toMillis();
        System.err.print("Sync complete. Time elapsed: ");
        System.err.print(timeElapsed);
        System.err.println("ms");
        System.exit(0);
    }

    static class JiraIntegrationInput
    extends Input {
        public int days;
        public String jiraURL;
        public String jiraUsername;
        public String jiraToken;
        public String resolutionOrStatus;
        public String resolvedStatus;
        public String hiddenStatus;
        public boolean debug;

        private JiraIntegrationInput(String raw) {
            super(raw);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Sync Jira (");
            builder.append(this.days);
            builder.append("d)");
            if (this.debug) {
                builder.append(" [debug]");
            }
            return builder.toString();
        }

        static JiraIntegrationInput of(String raw) {
            return new JiraIntegrationInput(raw);
        }
    }
}

