/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.udf.label;

import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.takipi.api.client.ApiClient;
import com.takipi.api.client.request.event.EventModifyLabelsRequest;
import com.takipi.api.client.request.label.CreateLabelRequest;
import com.takipi.api.core.request.intf.ApiPostRequest;
import com.takipi.api.core.url.UrlClient;
import com.takipi.udf.ContextArgs;
import com.takipi.udf.input.Input;
import org.apache.commons.lang3.StringUtils;

public class ApplyLabelFunction {
    public static String validateInput(String rawInput) {
        return ApplyLabelFunction.getLabelInput(rawInput).toString();
    }

    private static LabelInput getLabelInput(String rawInput) {
        LabelInput input;
        System.out.println("validateInput rawInput:" + rawInput);
        if (Strings.isNullOrEmpty((String)rawInput)) {
            throw new IllegalArgumentException("Input is empty");
        }
        try {
            input = LabelInput.of(rawInput);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        if (StringUtils.isEmpty((CharSequence)input.label)) {
            throw new IllegalArgumentException("Label name can't be empty");
        }
        return input;
    }

    public static void execute(String rawContextArgs, String rawInput) {
        CreateLabelRequest createLabel;
        LabelInput input = ApplyLabelFunction.getLabelInput(rawInput);
        ContextArgs args = (ContextArgs)new Gson().fromJson(rawContextArgs, ContextArgs.class);
        System.out.println("execute context: " + rawContextArgs);
        if (!args.validate()) {
            throw new IllegalArgumentException("Bad context args - " + rawContextArgs);
        }
        if (!args.eventValidate()) {
            return;
        }
        ApiClient apiClient = args.apiClient();
        UrlClient.Response createResult = apiClient.post((ApiPostRequest)(createLabel = CreateLabelRequest.newBuilder().setServiceId(args.serviceId).setName(input.label).build()));
        if (createResult.isBadResponse() && createResult.responseCode != 409) {
            throw new IllegalStateException("Can't create label " + (Object)((Object)input));
        }
        EventModifyLabelsRequest addLabel = EventModifyLabelsRequest.newBuilder().setServiceId(args.serviceId).setEventId(args.eventId).addLabel(input.label).build();
        UrlClient.Response addResult = apiClient.post((ApiPostRequest)addLabel);
        if (addResult.isBadResponse()) {
            throw new IllegalStateException("Can't apply label " + (Object)((Object)input) + " to event " + args.eventId);
        }
    }

    static class LabelInput
    extends Input {
        public String label;

        private LabelInput(String raw) {
            super(raw);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Label name - ");
            builder.append(this.label);
            return builder.toString();
        }

        static LabelInput of(String raw) {
            return new LabelInput(raw);
        }
    }
}

