/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.udf.microsoftteams;

import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.takipi.api.client.ApiClient;
import com.takipi.api.client.data.view.SummarizedView;
import com.takipi.api.client.request.event.EventRequest;
import com.takipi.api.client.request.event.EventsRequest;
import com.takipi.api.client.result.event.EventResult;
import com.takipi.api.client.result.event.EventsResult;
import com.takipi.api.client.util.event.EventUtil;
import com.takipi.api.client.util.view.ViewUtil;
import com.takipi.api.core.request.intf.ApiGetRequest;
import com.takipi.api.core.url.UrlClient;
import com.takipi.common.util.CollectionUtil;
import com.takipi.udf.ContextArgs;
import com.takipi.udf.microsoftteams.MicrosoftTeamsChannelRequest;
import com.takipi.udf.microsoftteams.MicrosoftTeamsInput;
import com.takipi.udf.microsoftteams.MicrosoftTeamsUtil;
import com.takipi.udf.microsoftteams.SimpleUrlClient;
import com.takipi.udf.util.TestUtil;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class MicrosoftTeamsChannelFunction {
    public static final int MINUTES_TIME_SPAN = 50000;

    public static String validateInput(String rawInput) {
        return MicrosoftTeamsChannelFunction.getInput(rawInput).toString();
    }

    private static MicrosoftTeamsInput getInput(String rawInput) {
        MicrosoftTeamsInput input;
        if (Strings.isNullOrEmpty((String)rawInput)) {
            throw new IllegalArgumentException("Input is empty");
        }
        try {
            input = MicrosoftTeamsInput.of(rawInput);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        input.checkUrl();
        return input;
    }

    public static void execute(String rawContextArgs, String rawInput) {
        try {
            MicrosoftTeamsChannelFunction.executeImplementation(rawContextArgs, rawInput);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void executeImplementation(String rawContextArgs, String rawInput) {
        MicrosoftTeamsUtil.logUDFInput(rawContextArgs, rawInput);
        MicrosoftTeamsInput input = MicrosoftTeamsChannelFunction.getInput(rawInput);
        ContextArgs args = (ContextArgs)new Gson().fromJson(rawContextArgs, ContextArgs.class);
        if (!args.validate()) {
            throw new IllegalArgumentException("Bad context args: " + rawContextArgs);
        }
        if (!args.eventValidate()) {
            return;
        }
        ApiClient apiClient = args.apiClient();
        UrlClient.Response<EventResult> eventResultResponse = MicrosoftTeamsChannelFunction.getEventResultResponse(args, apiClient);
        System.out.println("Got exceptionClassName, exception type, exceptionLocationPath, stack_frames, deployment");
        MicrosoftTeamsUtil.TimeSlot timeSlot = MicrosoftTeamsUtil.getTimeSlot(50000);
        String exceptionLinkToOverOps = EventUtil.getEventRecentLink((ApiClient)apiClient, (String)args.serviceId, (String)args.eventId, (DateTime)timeSlot.from, (DateTime)timeSlot.to, null, null, null);
        System.out.println("Got ARC link");
        EventResult eventResult = (EventResult)eventResultResponse.data;
        MicrosoftTeamsChannelRequest microsoftTeamsChannelRequest = MicrosoftTeamsChannelRequest.newBuilder().setUrl(input.url).setEventResult(eventResult).setExceptionLink(exceptionLinkToOverOps).setServer(eventResult.introduced_by_server).setApplication(eventResult.introduced_by_application).setEnvironmentName(MicrosoftTeamsUtil.getEnvironmentName(apiClient, args.serviceId)).setDeployment(eventResult.introduced_by).setDoNotAlertLink(MicrosoftTeamsChannelFunction.getDoNotAlertLink(args, eventResult.type)).build();
        UrlClient.Response<String> post = SimpleUrlClient.newBuilder().build().post(microsoftTeamsChannelRequest);
        System.out.println("Post Microsoft Teams Webhook Channel request");
        if (post.isBadResponse()) {
            throw new IllegalStateException("Can't send card to " + input.url);
        }
    }

    private static String getDoNotAlertLink(ContextArgs args, String exceptionType) {
        return args.appHost + "/index.html?key=" + args.serviceId + "&nav=archivemailitem&exception_class=" + Base64.getEncoder().encodeToString(exceptionType.getBytes());
    }

    private static UrlClient.Response<EventResult> getEventResultResponse(ContextArgs args, ApiClient apiClient) {
        EventRequest eventRequest = EventRequest.newBuilder().setEventId(args.eventId).setServiceId(args.serviceId).setIncludeStacktrace(true).build();
        UrlClient.Response eventResultResponse = apiClient.get((ApiGetRequest)eventRequest);
        if (!eventResultResponse.isOK() || eventResultResponse.data == null) {
            throw new IllegalStateException("Event is not present or api issue. eventId = " + args.eventId + " , serviceId = " + args.serviceId);
        }
        return eventResultResponse;
    }

    public static void main(String[] args) {
        ContextArgs contextArgs = TestUtil.getDefaultContextArgsBuilder().setApiKey("api_token").setServiceId("SXXXXX").build();
        SummarizedView view = ViewUtil.getServiceViewByName((ApiClient)contextArgs.apiClient(), (String)contextArgs.serviceId, (String)"View 1");
        contextArgs.viewId = view.id;
        MicrosoftTeamsUtil.TimeSlot timeSlot = MicrosoftTeamsUtil.getTimeSlot(50000);
        DateTimeFormatter fmt = ISODateTimeFormat.dateTime().withZoneUTC();
        EventsRequest eventsRequest = EventsRequest.newBuilder().setServiceId(contextArgs.serviceId).setViewId(contextArgs.viewId).setFrom(timeSlot.from.toString(fmt)).setTo(timeSlot.to.toString(fmt)).build();
        ApiClient apiClient = contextArgs.apiClient();
        UrlClient.Response eventsResponse = apiClient.get((ApiGetRequest)eventsRequest);
        if (eventsResponse.isBadResponse()) {
            throw new IllegalStateException("Failed getting events.");
        }
        EventsResult eventsResult = (EventsResult)eventsResponse.data;
        if (CollectionUtil.safeIsEmpty((Collection)eventsResult.events)) {
            System.out.println("NO EVENTS");
            return;
        }
        List events = eventsResult.events;
        contextArgs.eventId = ((EventResult)events.get((int)0)).id;
        String rawInput = "url=https://outlook.office.com/webhook/...";
        String rawContextArgs = new Gson().toJson((Object)contextArgs);
        MicrosoftTeamsChannelFunction.execute(rawContextArgs, rawInput);
    }
}

