/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.udf.microsoftteams;

import com.google.gson.Gson;
import com.takipi.api.client.data.event.Location;
import com.takipi.api.client.result.EmptyResult;
import com.takipi.api.client.result.event.EventResult;
import com.takipi.api.core.request.intf.ApiPostRequest;
import com.takipi.udf.microsoftteams.card.MicrosoftActivitySection;
import com.takipi.udf.microsoftteams.card.MicrosoftCard;
import com.takipi.udf.microsoftteams.card.MicrosoftFact;
import com.takipi.udf.microsoftteams.card.MicrosoftPotentialAction;
import com.takipi.udf.microsoftteams.card.MicrosoftTarget;
import com.takipi.udf.microsoftteams.card.MicrosoftTextBuilder;
import com.takipi.udf.microsoftteams.card.MicrosoftTextSection;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class MicrosoftTeamsChannelRequest
implements ApiPostRequest<EmptyResult> {
    public static final String THEME_COLOR = "ffc000";
    private final String url;
    private final String exceptionLinkToOverOps;
    private final String exceptionClassName;
    private final String exceptionLocationPath;
    private final List<Location> stack_frames;
    private final String deployment;
    private final String application;
    private final String server;
    private final String environmentsName;
    private final String reportedBy;
    private final String doNotAlertLink;

    public MicrosoftTeamsChannelRequest(String url, String exceptionLinkToOverOps, String exceptionClassName, String exceptionLocationPath, List<Location> stack_frames, String deployment, String application, String server, String environmentsName, String reportedBy, String doNotAlertLink) {
        this.url = url;
        this.exceptionLinkToOverOps = exceptionLinkToOverOps;
        this.exceptionClassName = exceptionClassName;
        this.exceptionLocationPath = exceptionLocationPath;
        this.stack_frames = stack_frames;
        this.deployment = deployment;
        this.application = application;
        this.server = server;
        this.environmentsName = environmentsName;
        this.reportedBy = reportedBy;
        this.doNotAlertLink = doNotAlertLink;
    }

    public String contentType() {
        return "application/json";
    }

    public String urlPath() {
        return this.url;
    }

    public String[] queryParams() throws UnsupportedEncodingException {
        return new String[0];
    }

    public String postData() {
        MicrosoftCard microsoftCard = MicrosoftCard.newBuilder().setThemeColor(THEME_COLOR).setText(new MicrosoftTextBuilder().add("A new ").addBold(this.exceptionClassName).add(" in ").addBold(this.exceptionLocationPath).add(" has been detected in ").addBold(this.environmentsName).add(StringUtils.isNotEmpty((CharSequence)this.reportedBy) ? new MicrosoftTextBuilder().add(" (alert added by ").addBold(this.reportedBy).add(")").build() : "").build()).addSections(new MicrosoftTextSection(new MicrosoftTextBuilder().addLink(this.exceptionLinkToOverOps, this.exceptionClassName).addEnter().addHighlighted(new MicrosoftTextBuilder().addArray(this.stack_frames, " at ").build()).build()), new MicrosoftActivitySection.Builder().addFacts(new MicrosoftFact("Server", this.server), new MicrosoftFact("Application", this.application), new MicrosoftFact("Deployment", this.deployment)).build()).addPotentialActions(MicrosoftPotentialAction.newBuilder().setName("View Event").addTargets(new MicrosoftTarget(this.exceptionLinkToOverOps)).build(), MicrosoftPotentialAction.newBuilder().setName("Do not alert on new " + this.exceptionClassName).addTargets(new MicrosoftTarget(this.doNotAlertLink)).build()).build();
        return new Gson().toJson((Object)microsoftCard);
    }

    public Class<EmptyResult> resultClass() {
        return EmptyResult.class;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String exceptionClassName = "";
        private String exceptionLocationPath = "";
        private List<Location> stack_frames = new ArrayList<Location>();
        private String deployment = "";
        private String application = "";
        private String server = "";
        private String environmentsName = "";
        private String url;
        private String exceptionLink = "";
        private String reportedBy = "";
        private String doNotAlertLink = "";

        public Builder setUrl(String url) {
            this.url = url;
            return this;
        }

        public Builder setEventResult(EventResult eventResult) {
            if (eventResult != null) {
                this.exceptionClassName = eventResult.name;
                this.exceptionLocationPath = eventResult.error_location.prettified_name;
                this.stack_frames = eventResult.stack_frames;
                this.deployment = eventResult.introduced_by;
            }
            return this;
        }

        public Builder setExceptionLink(String exceptionLink) {
            this.exceptionLink = exceptionLink;
            return this;
        }

        public Builder setServer(String server) {
            this.server = server;
            return this;
        }

        public Builder setApplication(String application) {
            this.application = application;
            return this;
        }

        public Builder setEnvironmentName(String environmentsName) {
            this.environmentsName = environmentsName;
            return this;
        }

        public Builder setDeployment(String deployment) {
            this.deployment = deployment;
            return this;
        }

        public Builder setReportedBy(String reportedBy) {
            this.reportedBy = reportedBy;
            return this;
        }

        public Builder setDoNotAlertLink(String doNotAlertLink) {
            this.doNotAlertLink = doNotAlertLink;
            return this;
        }

        public MicrosoftTeamsChannelRequest build() {
            return new MicrosoftTeamsChannelRequest(this.url, this.exceptionLink, this.exceptionClassName, this.exceptionLocationPath, this.stack_frames, this.deployment, this.application, this.server, this.environmentsName, this.reportedBy, this.doNotAlertLink);
        }
    }
}

