/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.udf.microsoftteams;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.takipi.api.core.request.intf.ApiPostRequest;
import com.takipi.api.core.result.intf.ApiResult;
import com.takipi.api.core.url.UrlClient;
import java.util.Map;

public class SimpleUrlClient
extends UrlClient {
    SimpleUrlClient(String hostname, int connectTimeout, int readTimeout, UrlClient.LogLevel defaultLogLevel, Map<Integer, UrlClient.LogLevel> responseLogLevels) {
        super(hostname, connectTimeout, readTimeout, defaultLogLevel, responseLogLevels);
    }

    public <T extends ApiResult> UrlClient.Response<String> post(ApiPostRequest<T> request) {
        try {
            String postData = request.postData();
            byte[] data = Strings.isNullOrEmpty((String)postData) ? null : postData.getBytes("UTF-8");
            return this.post(request.urlPath(), data, request.contentType(), request.queryParams());
        }
        catch (Exception e) {
            logger.error("Api url client POST {} failed.", (Object)request.getClass().getName(), (Object)e);
            return UrlClient.Response.of((int)500, null);
        }
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private static final int CONNECT_TIMEOUT = 15000;
        private static final int READ_TIMEOUT = 60000;
        private int connectTimeout = 15000;
        private int readTimeout = 60000;
        private UrlClient.LogLevel defaultLogLevel = UrlClient.LogLevel.ERROR;
        private Map<Integer, UrlClient.LogLevel> responseLogLevels = Maps.newHashMap();

        Builder() {
        }

        public Builder setConnectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder setReadTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public Builder setDefaultLogLevel(UrlClient.LogLevel defaultLogLevel) {
            this.defaultLogLevel = defaultLogLevel;
            return this;
        }

        public Builder setResponseLogLevels(Map<Integer, UrlClient.LogLevel> responseLogLevels) {
            this.responseLogLevels = responseLogLevels;
            return this;
        }

        public SimpleUrlClient build() {
            return new SimpleUrlClient("", this.connectTimeout, this.readTimeout, this.defaultLogLevel, (Map<Integer, UrlClient.LogLevel>)ImmutableMap.copyOf(this.responseLogLevels));
        }
    }
}

