/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.udf.microsoftteams.card;

import com.google.gson.annotations.SerializedName;
import com.takipi.udf.microsoftteams.card.MicrosoftTarget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MicrosoftPotentialAction {
    @SerializedName(value="@type")
    public final String type;
    public final String name;
    public final List<MicrosoftTarget> targets;

    public MicrosoftPotentialAction(String type, String name, List<MicrosoftTarget> targets) {
        this.type = type;
        this.name = name;
        this.targets = targets;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String type = "OpenUri";
        private String name = "";
        private List<MicrosoftTarget> targets = new ArrayList<MicrosoftTarget>();

        public Builder setType(String type) {
            this.type = type;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setTargets(List<MicrosoftTarget> targets) {
            this.targets = targets;
            return this;
        }

        public Builder addTargets(MicrosoftTarget ... targets) {
            if (this.targets == null) {
                this.targets = new ArrayList<MicrosoftTarget>();
            }
            this.targets.addAll(Arrays.asList(targets));
            return this;
        }

        public MicrosoftPotentialAction build() {
            return new MicrosoftPotentialAction(this.type, this.name, this.targets);
        }
    }
}

