/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.udf.severity;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.takipi.api.client.ApiClient;
import com.takipi.api.client.data.category.Category;
import com.takipi.api.client.data.event.Action;
import com.takipi.api.client.data.view.SummarizedView;
import com.takipi.api.client.request.event.EventActionsRequest;
import com.takipi.api.client.request.label.BatchModifyLabelsRequest;
import com.takipi.api.client.result.event.EventActionsResult;
import com.takipi.api.client.result.event.EventResult;
import com.takipi.api.client.result.event.EventsResult;
import com.takipi.api.client.util.category.CategoryUtil;
import com.takipi.api.client.util.label.LabelUtil;
import com.takipi.api.client.util.regression.RateRegression;
import com.takipi.api.client.util.regression.RegressionInput;
import com.takipi.api.client.util.regression.RegressionResult;
import com.takipi.api.client.util.regression.RegressionUtil;
import com.takipi.api.client.util.view.ViewUtil;
import com.takipi.api.core.request.intf.ApiGetRequest;
import com.takipi.api.core.request.intf.ApiPostRequest;
import com.takipi.api.core.url.UrlClient;
import com.takipi.common.util.Pair;
import com.takipi.udf.ContextArgs;
import com.takipi.udf.input.Input;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;

public class SeverityFunction {
    public static String validateInput(String rawInput) {
        return SeverityFunction.parseSeverityInput(rawInput).toString();
    }

    static SeverityInput parseSeverityInput(String rawInput) {
        SeverityInput input;
        System.out.println("validateInput rawInput:" + rawInput);
        if (Strings.isNullOrEmpty((String)rawInput)) {
            throw new IllegalArgumentException("Input is empty");
        }
        try {
            input = SeverityInput.of(rawInput);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        if (input.activeTimespan <= 0) {
            throw new IllegalArgumentException("'activeTimespan' must be positive'");
        }
        if (input.baseTimespan <= 0) {
            throw new IllegalArgumentException("'timespan' must be positive");
        }
        if (input.regressionDelta <= 0.0) {
            throw new IllegalArgumentException("'regressionDelta' must be positive");
        }
        if (input.criticalRegressionDelta < 0.0) {
            throw new IllegalArgumentException("'criticalRegressionDelta' can't be negative");
        }
        if (input.newEventslabel == null) {
            throw new IllegalArgumentException("'newEventslabel' must exist");
        }
        if (input.regressedEventsLabel == null) {
            throw new IllegalArgumentException("'regressedEventsLabel' must exist");
        }
        return input;
    }

    public static void execute(String rawContextArgs, String rawInput) {
        System.out.println("execute:" + rawContextArgs);
        ContextArgs args = (ContextArgs)new Gson().fromJson(rawContextArgs, ContextArgs.class);
        if (!args.viewValidate()) {
            throw new IllegalArgumentException("Invalid context args - " + rawContextArgs);
        }
        SeverityInput input = SeverityFunction.parseSeverityInput(rawInput);
        SeverityFunction.setupSeverityViews(args, input);
        System.out.println("Calculating regressions\n");
        RegressionInput regressionInput = new RegressionInput();
        regressionInput.serviceId = args.serviceId;
        regressionInput.viewId = args.viewId;
        regressionInput.activeTimespan = input.activeTimespan;
        regressionInput.baselineTimespan = input.baseTimespan;
        regressionInput.minVolumeThreshold = input.minVolumeThreshold;
        regressionInput.minErrorRateThreshold = input.minErrorRateThreshold;
        regressionInput.regressionDelta = input.regressionDelta;
        regressionInput.criticalRegressionDelta = input.criticalRegressionDelta;
        regressionInput.applySeasonality = input.applySeasonality;
        regressionInput.criticalExceptionTypes = input.criticalExceptionTypes;
        RateRegression rateRegression = RegressionUtil.calculateRateRegressions((ApiClient)args.apiClient(), (RegressionInput)regressionInput, (PrintStream)System.out, (boolean)false);
        HashMap allNewAndCritical = Maps.newHashMap();
        if (input.newEventsView != null) {
            allNewAndCritical.putAll(rateRegression.getExceededNewEvents());
            allNewAndCritical.putAll(rateRegression.getCriticalNewEvents());
            SeverityFunction.applySeverityLabels(args, input.newEventslabel, input.newEventsView, input.labelRetention, Lists.newArrayList(allNewAndCritical.values()));
        }
        if (input.regressedEventsView != null) {
            Collection activeRegressions = rateRegression.getAllRegressions().values();
            ArrayList activeRegressionEvents = Lists.newArrayListWithCapacity((int)activeRegressions.size());
            for (RegressionResult activeRegression : activeRegressions) {
                activeRegressionEvents.add(activeRegression.getEvent());
            }
            SeverityFunction.applySeverityLabels(args, input.regressedEventsLabel, input.regressedEventsView, input.labelRetention, activeRegressionEvents);
        }
    }

    private static void setupSeverityViews(ContextArgs args, SeverityInput input) {
        String categoryId = SeverityFunction.createSeverityCategory(args, input);
        LabelUtil.createLabelsIfNotExists((ApiClient)args.apiClient(), (String)args.serviceId, (String[])new String[]{input.newEventslabel, input.regressedEventsLabel});
        ArrayList views = Lists.newArrayList();
        if (input.newEventsView != null) {
            views.add(Pair.of((Object)input.newEventsView, (Object)input.newEventslabel));
        }
        if (input.regressedEventsView != null) {
            views.add(Pair.of((Object)input.regressedEventsView, (Object)input.regressedEventsLabel));
        }
        if (views.size() > 0) {
            ViewUtil.createLabelViewsIfNotExists((ApiClient)args.apiClient(), (String)args.serviceId, (Collection)views, (boolean)true, (String)categoryId);
        }
    }

    private static String createSeverityCategory(ContextArgs args, SeverityInput input) {
        String result;
        Category category = CategoryUtil.getServiceCategoryByName((ApiClient)args.apiClient(), (String)args.serviceId, (String)input.category);
        if (category == null) {
            result = CategoryUtil.createCategory((String)input.category, (String)args.serviceId, (ApiClient)args.apiClient());
            System.out.println("Created category " + result + " for " + input.category);
        } else {
            result = category.id;
        }
        return result;
    }

    private static void applySeverityLabels(ContextArgs args, String label, String viewName, int labelRetention, Collection<EventResult> targetEvents) {
        ApiClient apiClient = args.apiClient();
        HashMap newlyLabeledEvents = Maps.newHashMap();
        boolean modified = false;
        BatchModifyLabelsRequest.Builder builder = BatchModifyLabelsRequest.newBuilder().setServiceId(args.serviceId).setHandleSimilarEvents(false);
        for (EventResult event : targetEvents) {
            boolean hasLabel;
            boolean bl = hasLabel = event.labels != null && event.labels.contains(label);
            if (!hasLabel) {
                modified = true;
                newlyLabeledEvents.put(event.id, event);
                builder.addLabelModifications(event.id, Collections.singleton(label), Collections.emptyList());
                System.out.println("Applying label " + label + " to " + event.id);
                continue;
            }
            System.out.println("Event " + event.id + " already has label " + label);
        }
        DateTime now = DateTime.now();
        DateTime retentionTime = now.minusMinutes(labelRetention * 2);
        SummarizedView view = ViewUtil.getServiceViewByName((ApiClient)apiClient, (String)args.serviceId, (String)viewName);
        if (view == null) {
            System.out.println("Could not get view " + viewName);
            return;
        }
        EventsResult previousEvents = ViewUtil.getEventsVolume((ApiClient)apiClient, (String)args.serviceId, (String)view.id, (DateTime)retentionTime, (DateTime)now);
        DateTime retentionWindow = DateTime.now().minusMinutes(labelRetention);
        if (previousEvents != null && previousEvents.events != null) {
            for (int i = 0; i < previousEvents.events.size(); ++i) {
                EventResult event = (EventResult)previousEvents.events.get(i);
                if (targetEvents.contains(event) || newlyLabeledEvents.containsKey(event.id) || event.labels == null || !event.labels.contains(label)) continue;
                EventActionsRequest eventActionsRequest = EventActionsRequest.newBuilder().setServiceId(args.serviceId).setEventId(event.id).build();
                UrlClient.Response eventsActionsResponse = apiClient.get((ApiGetRequest)eventActionsRequest);
                if (eventsActionsResponse.isBadResponse()) {
                    System.err.println("Can't create events actions for event " + event.id);
                }
                if (((EventActionsResult)eventsActionsResponse.data).event_actions == null) continue;
                boolean keepLabel = false;
                for (Action action : ((EventActionsResult)eventsActionsResponse.data).event_actions) {
                    DateTime labelAddTime;
                    if (!label.equals(action.data) || !"ADD_LABEL".equals(action.action.toUpperCase()) || !(labelAddTime = ISODateTimeFormat.dateTimeParser().parseDateTime(action.timestamp)).isAfter((ReadableInstant)retentionWindow)) continue;
                    keepLabel = true;
                    System.out.println("Keeping label " + label + " on " + event.id);
                    break;
                }
                if (keepLabel) continue;
                modified = true;
                System.out.println("Removing label " + label + " from " + event.id);
                builder.addLabelModifications(event.id, Collections.emptyList(), Collections.singleton(label));
            }
        }
        if (!modified) {
            return;
        }
        UrlClient.Response response = apiClient.post((ApiPostRequest)builder.build());
        if (!response.isOK()) {
            System.out.println("Error adding /  removing labels " + response.responseCode);
        }
    }

    static class SeverityInput
    extends Input {
        public int activeTimespan;
        public int baseTimespan;
        public double regressionDelta;
        public double criticalRegressionDelta;
        public boolean applySeasonality;
        public List<String> criticalExceptionTypes;
        public double minErrorRateThreshold;
        public int minVolumeThreshold;
        public String category;
        public String newEventslabel;
        public String regressedEventsLabel;
        public String newEventsView;
        public String regressedEventsView;
        public int labelRetention;

        private SeverityInput(String raw) {
            super(raw);
        }

        static SeverityInput of(String raw) {
            return new SeverityInput(raw);
        }

        public String toString() {
            return String.format("Severe(Window = %d, Baseline = %d, Thresh = %d, Rate = %.2f)", this.activeTimespan, this.baseTimespan, this.minVolumeThreshold, this.minErrorRateThreshold);
        }
    }
}

