/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.udf.timer;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.takipi.api.client.ApiClient;
import com.takipi.api.client.data.timer.Timer;
import com.takipi.api.client.data.transaction.Stats;
import com.takipi.api.client.data.transaction.TransactionGraph;
import com.takipi.api.client.data.view.SummarizedView;
import com.takipi.api.client.request.event.BatchForceSnapshotsRequest;
import com.takipi.api.client.request.event.EventsRequest;
import com.takipi.api.client.request.label.BatchModifyLabelsRequest;
import com.takipi.api.client.request.redaction.CodeRedactionExcludeRequest;
import com.takipi.api.client.request.transactiontimer.CreateTransactionTimerRequest;
import com.takipi.api.client.request.transactiontimer.EditTransactionTimerRequest;
import com.takipi.api.client.request.transactiontimer.ToggleTransactionTimerRequest;
import com.takipi.api.client.request.transactiontimer.TransactionTimersRequest;
import com.takipi.api.client.result.event.EventResult;
import com.takipi.api.client.result.event.EventsResult;
import com.takipi.api.client.result.redaction.CodeRedactionElements;
import com.takipi.api.client.result.transactiontimer.TransactionTimersResult;
import com.takipi.api.client.util.performance.PerformanceUtil;
import com.takipi.api.client.util.performance.calc.PerformanceCalculator;
import com.takipi.api.client.util.performance.calc.PerformanceScore;
import com.takipi.api.client.util.performance.calc.PerformanceState;
import com.takipi.api.client.util.performance.transaction.GraphPerformanceCalculator;
import com.takipi.api.client.util.transaction.TransactionUtil;
import com.takipi.api.client.util.view.ViewUtil;
import com.takipi.api.core.request.intf.ApiGetRequest;
import com.takipi.api.core.request.intf.ApiPostRequest;
import com.takipi.api.core.url.UrlClient;
import com.takipi.common.util.CollectionUtil;
import com.takipi.common.util.Pair;
import com.takipi.udf.ContextArgs;
import com.takipi.udf.input.Input;
import com.takipi.udf.input.TimeInterval;
import com.takipi.udf.util.JavaUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class PeriodicAvgTimerFunction {
    private static final String TIMERS_VIEW_NAME = "My Timers";
    private static final long DRFAULT_MAX_AVGTIME_THRESHOLD = TimeUnit.MINUTES.toMillis(15L);

    public static String validateInput(String rawInput) {
        return PeriodicAvgTimerFunction.getPeriodicAvgTimerInput(rawInput).toString();
    }

    static PeriodicAvgTimerInput getPeriodicAvgTimerInput(String rawInput) {
        PeriodicAvgTimerInput input;
        System.out.println("validateInput rawInput:" + rawInput);
        if (Strings.isNullOrEmpty((String)rawInput)) {
            throw new IllegalArgumentException("Input is empty");
        }
        try {
            input = PeriodicAvgTimerInput.of(rawInput);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        if (input.active_timespan == null) {
            throw new IllegalArgumentException("Missing 'active_timespan'");
        }
        if (!input.active_timespan.isPositive()) {
            throw new IllegalArgumentException("'active_timespan' must be positive");
        }
        if (input.baseline_timespan == null) {
            throw new IllegalArgumentException("Missing 'baseline_timespan'");
        }
        if (!input.baseline_timespan.isPositive()) {
            throw new IllegalArgumentException("'active_timespan' must be positive");
        }
        if (input.baseline_timespan.asMinutes() <= input.active_timespan.asMinutes()) {
            throw new IllegalArgumentException("'baseline_timespan' must be larger than 'active_timespan'");
        }
        if (input.active_timespan_point_res <= 0) {
            throw new IllegalArgumentException("'active_timespan_point_res' must be positive");
        }
        if (input.baseline_timespan_point_res <= 0) {
            throw new IllegalArgumentException("'baseline_timespan_point_res' must be positive");
        }
        if (input.active_invocations_threshold <= 0L) {
            throw new IllegalArgumentException("'active_invocations_threshold' must be positive");
        }
        if (input.baseline_invocations_threshold <= 0L) {
            throw new IllegalArgumentException("'baseline_invocations_threshold' must be positive");
        }
        if (input.min_delta_threshold < 0) {
            throw new IllegalArgumentException("'min_delta_threshold' can't be negative");
        }
        if (input.over_avg_slowing_percentage <= 0.0) {
            throw new IllegalArgumentException("'over_avg_slowing_percentage' must be positive");
        }
        if (input.over_avg_slowing_percentage > 1.0) {
            throw new IllegalArgumentException("'over_avg_slowing_percentage' can't be greater than 1.0");
        }
        if (input.over_avg_critical_percentage <= 0.0) {
            throw new IllegalArgumentException("'over_avg_critical_percentage' must be positive");
        }
        if (input.over_avg_critical_percentage > 1.0) {
            throw new IllegalArgumentException("'over_avg_critical_percentage' can't be greater than 1.0");
        }
        if (input.over_avg_critical_percentage <= input.over_avg_slowing_percentage) {
            throw new IllegalArgumentException("'over_avg_critical_percentage' must be larger than 'over_avg_slowing_percentage'");
        }
        if (input.std_dev_factor <= 0.0) {
            throw new IllegalArgumentException("'std_dev_factor' must be positive");
        }
        if (input.timer_std_dev_factor < 0.0) {
            throw new IllegalArgumentException("'timer_std_dev_factor' can't be negative");
        }
        if (input.min_timer_threshold <= 0L) {
            throw new IllegalArgumentException("'min_timer_threshold' must be positive");
        }
        return input;
    }

    public static void execute(String rawContextArgs, String rawInput) {
        PeriodicAvgTimerInput input = PeriodicAvgTimerFunction.getPeriodicAvgTimerInput(rawInput);
        ContextArgs args = (ContextArgs)new Gson().fromJson(rawContextArgs, ContextArgs.class);
        System.out.println("execute context: " + rawContextArgs);
        if (!args.validate()) {
            throw new IllegalArgumentException("Bad context args - " + rawContextArgs);
        }
        if (!args.viewValidate()) {
            return;
        }
        ApiClient apiClient = args.apiClient();
        SummarizedView timersView = ViewUtil.getServiceViewByName((ApiClient)apiClient, (String)args.serviceId, (String)TIMERS_VIEW_NAME);
        if (timersView == null) {
            throw new IllegalStateException("Failed getting timers view.");
        }
        DateTime to = DateTime.now();
        DateTime activeFrom = to.minusMinutes(input.active_timespan.asMinutes());
        Map activeTransactions = TransactionUtil.getTransactionGraphs((ApiClient)apiClient, (String)args.serviceId, (String)args.viewId, (DateTime)activeFrom, (DateTime)to, (int)input.active_timespan_point_res);
        if (CollectionUtil.safeIsEmpty((Map)activeTransactions)) {
            return;
        }
        DateTime baselineFrom = to.minusMinutes(input.baseline_timespan.asMinutes());
        Map baselineTransactions = TransactionUtil.getTransactionGraphs((ApiClient)apiClient, (String)args.serviceId, (String)args.viewId, (DateTime)baselineFrom, (DateTime)to, (int)input.baseline_timespan_point_res);
        GraphPerformanceCalculator calculator = GraphPerformanceCalculator.of((long)input.active_invocations_threshold, (long)input.baseline_invocations_threshold, (int)input.min_delta_threshold, (double)input.min_delta_threshold_percentage, (double)input.over_avg_slowing_percentage, (double)input.over_avg_critical_percentage, (double)input.std_dev_factor, (long)DRFAULT_MAX_AVGTIME_THRESHOLD);
        Map performance = PerformanceUtil.getPerformanceStates((Map)activeTransactions, (Map)baselineTransactions, (PerformanceCalculator)calculator);
        DateTimeFormatter fmt = ISODateTimeFormat.dateTime().withZoneUTC();
        EventsRequest eventsRequest = EventsRequest.newBuilder().setServiceId(args.serviceId).setViewId(timersView.id).setFrom(baselineFrom.toString(fmt)).setTo(to.toString(fmt)).build();
        UrlClient.Response eventsResponse = apiClient.get((ApiGetRequest)eventsRequest);
        if (eventsResponse.isBadResponse()) {
            throw new IllegalStateException("Failed getting view events.");
        }
        EventsResult eventsResult = (EventsResult)eventsResponse.data;
        TransactionTimersRequest transactionTimersRequest = TransactionTimersRequest.newBuilder().setServiceId(args.serviceId).build();
        UrlClient.Response transactionTimersResponse = apiClient.get((ApiGetRequest)transactionTimersRequest);
        if (transactionTimersResponse.isBadResponse()) {
            throw new IllegalStateException("Failed getting timers.");
        }
        CodeRedactionExcludeRequest excludeRequest = CodeRedactionExcludeRequest.newBuilder().setServiceId(args.serviceId).build();
        UrlClient.Response excludeResponse = apiClient.get((ApiGetRequest)excludeRequest);
        if (excludeResponse.isBadResponse()) {
            throw new IllegalStateException("Failed exclude filters.");
        }
        Map<TransactionGraph, List<EventResult>> eventsMap = PeriodicAvgTimerFunction.buildTransactionEvents(activeTransactions.values(), eventsResult.events);
        boolean labelsUpdateNeeded = false;
        BatchModifyLabelsRequest.Builder labelsRequestBuilder = BatchModifyLabelsRequest.newBuilder().setServiceId(args.serviceId).setHandleSimilarEvents(false);
        HashMap newTimers = Maps.newHashMap();
        HashMap updatedTimers = Maps.newHashMap();
        ArrayList removedTimers = Lists.newArrayList();
        HashSet existingLabels = Sets.newHashSet();
        HashSet eventsToForceSnapshot = Sets.newHashSet();
        for (Map.Entry entry : performance.entrySet()) {
            PerformanceState state;
            TransactionGraph transaction = (TransactionGraph)entry.getKey();
            if (Strings.isNullOrEmpty((String)transaction.method_name)) continue;
            List<Object> transactionEvents = eventsMap.get(transaction);
            if (transactionEvents == null) {
                transactionEvents = Collections.emptyList();
            }
            TransactionName transactionName = TransactionName.of(JavaUtil.toInternalName((String)transaction.class_name), transaction.method_name);
            Timer timer = PeriodicAvgTimerFunction.getExistingTransactionTimer(transactionName, ((TransactionTimersResult)transactionTimersResponse.data).transaction_timers);
            boolean excludedTransaction = PeriodicAvgTimerFunction.isExcludedTransaction(transaction, (CodeRedactionElements)excludeResponse.data);
            PerformanceScore score = (PerformanceScore)entry.getValue();
            PerformanceState performanceState = state = excludedTransaction ? PerformanceState.NO_DATA : score.state;
            if (PeriodicAvgTimerFunction.addLabelModifications(transactionEvents, state, labelsRequestBuilder, existingLabels, args.serviceId, apiClient)) {
                labelsUpdateNeeded = true;
            }
            if (state == PerformanceState.NO_DATA) {
                if (timer == null || input.timer_always_on) continue;
                removedTimers.add(timer.id);
                continue;
            }
            if (state == PerformanceState.OK) {
                if (timer == null) {
                    if (!input.monitor_ok_transactions) {
                        continue;
                    }
                } else if (!input.monitor_ok_transactions && !input.timer_always_on) {
                    removedTimers.add(timer.id);
                    continue;
                }
            }
            Stats stats = TransactionUtil.aggregateGraph((TransactionGraph)transaction);
            long timerThreshold = (long)(stats.avg_time + stats.avg_time_std_deviation * input.timer_std_dev_factor);
            if (timerThreshold < input.min_timer_threshold) continue;
            if (timer == null) {
                newTimers.put(transactionName, timerThreshold);
            } else {
                updatedTimers.put(timer.id, timerThreshold);
            }
            for (EventResult eventResult : transactionEvents) {
                eventsToForceSnapshot.add(eventResult.id);
            }
        }
        for (Map.Entry entry : newTimers.entrySet()) {
            TransactionName transactionName = (TransactionName)entry.getKey();
            long threshold = (Long)entry.getValue();
            CreateTransactionTimerRequest createTransactionTimerRequest = CreateTransactionTimerRequest.newBuilder().setServiceId(args.serviceId).setClassName(transactionName.className).setMethodName(transactionName.methodName).setThreshold(threshold).build();
            apiClient.post((ApiPostRequest)createTransactionTimerRequest);
        }
        for (Map.Entry entry : updatedTimers.entrySet()) {
            String timerId = (String)entry.getKey();
            long threshold = (Long)entry.getValue();
            EditTransactionTimerRequest editTransactionTimerRequest = EditTransactionTimerRequest.newBuilder().setServiceId(args.serviceId).setTimerId(Integer.parseInt(timerId)).setThreshold(threshold).build();
            apiClient.post((ApiPostRequest)editTransactionTimerRequest);
        }
        for (String timerId : removedTimers) {
            ToggleTransactionTimerRequest toggleTransactionTimerRequest = ToggleTransactionTimerRequest.newBuilder().setServiceId(args.serviceId).setTimerId(Integer.parseInt(timerId)).setEnable(false).build();
            apiClient.post((ApiPostRequest)toggleTransactionTimerRequest);
        }
        if (labelsUpdateNeeded) {
            apiClient.post((ApiPostRequest)labelsRequestBuilder.build());
        }
        if (!eventsToForceSnapshot.isEmpty()) {
            BatchForceSnapshotsRequest forceSnapshotsRequest = BatchForceSnapshotsRequest.newBuilder().setServiceId(args.serviceId).addEventIds((Collection)eventsToForceSnapshot).build();
            apiClient.post((ApiPostRequest)forceSnapshotsRequest);
        }
    }

    private static boolean addLabelModifications(List<EventResult> events, PerformanceState state, BatchModifyLabelsRequest.Builder labelsRequestBuilder, Set<String> existingLabels, String serviceId, ApiClient apiClient) {
        boolean hasModifications = false;
        for (EventResult event : events) {
            Pair modifications = PerformanceUtil.categorizeEvent((EventResult)event, (String)serviceId, (PerformanceState)state, existingLabels, (ApiClient)apiClient, (boolean)false);
            Collection labelsToAdd = (Collection)modifications.getFirst();
            Collection labelsToRemove = (Collection)modifications.getSecond();
            if (labelsToAdd.isEmpty() && labelsToRemove.isEmpty()) continue;
            labelsRequestBuilder.addLabelModifications(event.id, labelsToAdd, labelsToRemove);
            hasModifications = true;
        }
        return hasModifications;
    }

    private static Map<TransactionGraph, List<EventResult>> buildTransactionEvents(Collection<TransactionGraph> transactions, List<EventResult> events) {
        if (CollectionUtil.safeIsEmpty(events)) {
            return Collections.emptyMap();
        }
        HashMap result = Maps.newHashMap();
        for (EventResult event : events) {
            if (event.entry_point == null || Strings.isNullOrEmpty((String)event.entry_point.class_name) || Strings.isNullOrEmpty((String)event.entry_point.method_name)) continue;
            for (TransactionGraph transaction : transactions) {
                if (!JavaUtil.toInternalName((String)event.entry_point.class_name).equals(transaction.class_name) || !Strings.isNullOrEmpty((String)transaction.method_name) && !event.entry_point.method_name.equals(transaction.method_name)) continue;
                List transactionEvents = (List)result.get(transaction);
                if (transactionEvents == null) {
                    transactionEvents = Lists.newArrayList();
                    result.put(transaction, transactionEvents);
                }
                transactionEvents.add(event);
            }
        }
        return result;
    }

    private static boolean isExcludedTransaction(TransactionGraph transaction, CodeRedactionElements redactionElements) {
        if (redactionElements == null) {
            return false;
        }
        if (!CollectionUtil.safeIsEmpty((Collection)redactionElements.packages)) {
            for (String packageName : redactionElements.packages) {
                if (!transaction.class_name.startsWith(packageName)) continue;
                return true;
            }
        }
        if (!CollectionUtil.safeIsEmpty((Collection)redactionElements.classes)) {
            String simpleTransactionName = JavaUtil.toSimpleClassName((String)transaction.class_name);
            for (String className : redactionElements.classes) {
                String simpleClassName = JavaUtil.toSimpleClassName((String)className);
                if (!simpleTransactionName.equals(simpleClassName)) continue;
                return true;
            }
        }
        return false;
    }

    private static Timer getExistingTransactionTimer(TransactionName transactionName, List<Timer> timers) {
        if (CollectionUtil.safeIsEmpty(timers)) {
            return null;
        }
        for (Timer timer : timers) {
            if (!transactionName.className.equals(JavaUtil.toInternalName((String)timer.class_name)) || !transactionName.methodName.equals(timer.method_name)) continue;
            return timer;
        }
        return null;
    }

    static class PeriodicAvgTimerInput
    extends Input {
        public TimeInterval active_timespan;
        public int active_timespan_point_res;
        public TimeInterval baseline_timespan;
        public int baseline_timespan_point_res;
        public long active_invocations_threshold;
        public long baseline_invocations_threshold;
        public int min_delta_threshold;
        public double min_delta_threshold_percentage = 0.2;
        public double over_avg_slowing_percentage;
        public double over_avg_critical_percentage;
        public double std_dev_factor;
        public double timer_std_dev_factor = 1.0;
        public boolean timer_always_on;
        public boolean monitor_ok_transactions;
        public long min_timer_threshold;

        private PeriodicAvgTimerInput(String raw) {
            this.initFields(raw);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("PeriodicAvgTimer(");
            builder.append(this.active_timespan.asMinutes());
            builder.append(")");
            return builder.toString();
        }

        static PeriodicAvgTimerInput of(String raw) {
            return new PeriodicAvgTimerInput(raw);
        }
    }

    static class TransactionName {
        public final String className;
        public final String methodName;

        private TransactionName(String className, String methodName) {
            this.className = className;
            this.methodName = methodName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || !(o instanceof TransactionName)) {
                return false;
            }
            TransactionName other = (TransactionName)o;
            return this.className.equals(other.className) && this.methodName.equals(other.methodName);
        }

        public int hashCode() {
            return this.className.hashCode();
        }

        static TransactionName of(String className, String methodName) {
            return new TransactionName(className, methodName);
        }
    }
}

