/*
 * Decompiled with CFR 0.152.
 */
package com.takipi.udf.volume;

import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.takipi.api.client.ApiClient;
import com.takipi.api.client.data.transaction.Transaction;
import com.takipi.api.client.request.event.EventsVolumeRequest;
import com.takipi.api.client.result.event.EventResult;
import com.takipi.api.client.result.event.EventsResult;
import com.takipi.api.client.util.transaction.TransactionUtil;
import com.takipi.api.client.util.validation.ValidationUtil;
import com.takipi.api.core.request.intf.ApiGetRequest;
import com.takipi.api.core.url.UrlClient;
import com.takipi.udf.ContextArgs;
import com.takipi.udf.input.Input;
import com.takipi.udf.input.TimeInterval;
import com.takipi.udf.volume.AnomalyUtil;
import com.takipi.udf.volume.ThresholdUtil;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class ThresholdFunction {
    private static final int DEFAULT_TIME_WINDOW = 60;
    private static final DateTimeFormatter fmt = ISODateTimeFormat.dateTime().withZoneUTC();

    static ThresholdInput getThresholdInput(String rawInput) {
        ThresholdInput input;
        System.out.println("validateInput rawInput:" + rawInput);
        if (Strings.isNullOrEmpty((String)rawInput)) {
            throw new IllegalArgumentException("Input is empty");
        }
        try {
            input = ThresholdInput.of(rawInput);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        if (input.timespan != null && !input.timespan.isPositive()) {
            throw new IllegalArgumentException("'timespan' must be positive");
        }
        if (input.threshold <= 0L && input.relative_to == Mode.Absolute) {
            throw new IllegalArgumentException("'threshold' must be positive");
        }
        if (input.threshold < 0L) {
            throw new IllegalArgumentException("'threshold' must be positive");
        }
        if (input.relative_to == Mode.Method_Calls && input.rate <= 0.0) {
            throw new IllegalArgumentException("'rate' must be positive");
        }
        if (input.relative_to == Mode.Thread_Calls && input.rate <= 0.0) {
            throw new IllegalArgumentException("'rate' must be positive");
        }
        if (input.label == null) {
            input.label = "Anomaly";
        }
        if (input.min_interval == null) {
            input.min_interval = TimeInterval.parse((String)"2d");
        } else if (input.min_interval.isNegative()) {
            throw new IllegalArgumentException("'min_interval' can't be negative time");
        }
        if (input.max_interval == null) {
            input.max_interval = TimeInterval.parse((String)"3d");
        } else if (input.max_interval.isNegative()) {
            throw new IllegalArgumentException("'max_interval' can't be negative time");
        }
        if (input.max_interval.asMinutes() <= input.min_interval.asMinutes()) {
            throw new IllegalArgumentException("'max_interval' must be greater than 'min_interval'");
        }
        return input;
    }

    private static List<EventResult> getEventVolume(ApiClient apiClient, String serviceId, String viewId, DateTime from, DateTime to, ValidationUtil.VolumeType volumeType) {
        EventsVolumeRequest eventsVolumeRequest = EventsVolumeRequest.newBuilder().setServiceId(serviceId).setViewId(viewId).setFrom(from.toString(fmt)).setTo(to.toString(fmt)).setVolumeType(volumeType).build();
        UrlClient.Response eventsVolumeResponse = apiClient.get((ApiGetRequest)eventsVolumeRequest);
        if (eventsVolumeResponse.isBadResponse()) {
            throw new IllegalStateException("Can't create events volume.");
        }
        EventsResult eventsVolumeResult = (EventsResult)eventsVolumeResponse.data;
        if (eventsVolumeResult == null) {
            throw new IllegalStateException("Missing events volume result.");
        }
        return eventsVolumeResult.events;
    }

    private static long getTransactionVolume(ApiClient apiClient, String serviceId, String viewId, DateTime from, DateTime to) {
        Map transactions = TransactionUtil.getTransactions((ApiClient)apiClient, (String)serviceId, (String)viewId, (DateTime)from, (DateTime)to);
        long result = 0L;
        for (Transaction transaction : transactions.values()) {
            if (transaction.stats == null) continue;
            result += transaction.stats.invocations;
        }
        return result;
    }

    static void execute(String rawContextArgs, ThresholdInput input) {
        System.out.println("execute:" + rawContextArgs);
        ContextArgs args = (ContextArgs)new Gson().fromJson(rawContextArgs, ContextArgs.class);
        if (!args.viewValidate()) {
            throw new IllegalArgumentException("Invalid context args - " + rawContextArgs);
        }
        ApiClient apiClient = args.apiClient();
        ValidationUtil.VolumeType volumeType = input.relative_to == null || input.relative_to == Mode.Method_Calls ? ValidationUtil.VolumeType.all : ValidationUtil.VolumeType.hits;
        int timespan = input.timespan != null ? input.timespan.asMinutes() : 60;
        DateTime to = DateTime.now();
        DateTime from = to.minusMinutes(timespan);
        List<EventResult> events = ThresholdFunction.getEventVolume(apiClient, args.serviceId, args.viewId, from, to, volumeType);
        if (events == null) {
            return;
        }
        AnomalyUtil.removeAnomalyLabel(events, apiClient, args.serviceId, input.max_interval, input.label);
        List<EventResult> relevantEvents = AnomalyUtil.filterAnomalyEvents(events, apiClient, args.serviceId, input.min_interval, input.label, 0);
        if (relevantEvents.isEmpty()) {
            return;
        }
        long hitCount = ThresholdUtil.getEventsHits(relevantEvents);
        if (input.threshold > 0L && hitCount <= input.threshold) {
            return;
        }
        boolean thresholdExceeded = false;
        Mode mode = input.relative_to != null ? input.relative_to : Mode.Method_Calls;
        ThresholdUtil.sortEventsByHitsDesc(relevantEvents);
        switch (mode) {
            case Absolute: {
                thresholdExceeded = true;
                break;
            }
            case Method_Calls: {
                long invocationsCount = ThresholdUtil.getEventsInvocations(relevantEvents, hitCount);
                double failRate = (double)hitCount / (double)invocationsCount * 100.0;
                thresholdExceeded = failRate >= input.rate;
                break;
            }
            case Thread_Calls: {
                long transactionInvocationsCount = ThresholdFunction.getTransactionVolume(apiClient, args.serviceId, args.viewId, from, to);
                if (transactionInvocationsCount <= 0L) break;
                double failRate = (double)hitCount / (double)transactionInvocationsCount * 100.0;
                thresholdExceeded = failRate >= input.rate;
                break;
            }
        }
        System.out.println("Threshold response: " + thresholdExceeded);
        if (!thresholdExceeded) {
            return;
        }
        List<EventResult> contributors = relevantEvents.subList(0, Math.min(relevantEvents.size(), 10));
        AnomalyUtil.reportAnomaly(apiClient, args.serviceId, args.viewId, contributors, input.label, from, to, input.toString());
    }

    public static enum Mode {
        Absolute,
        Method_Calls,
        Thread_Calls;

    }

    static class ThresholdInput
    extends Input {
        public Mode relative_to;
        public long threshold;
        public double rate;
        public TimeInterval timespan;
        public String label;
        public TimeInterval min_interval;
        public TimeInterval max_interval;

        private ThresholdInput(String raw) {
            super(raw);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Threshold(");
            Mode mode = this.relative_to != null ? this.relative_to : Mode.Method_Calls;
            switch (mode) {
                case Absolute: {
                    builder.append(this.threshold);
                    break;
                }
                case Method_Calls: 
                case Thread_Calls: {
                    builder.append(String.format("%.2f", this.rate));
                    builder.append('%');
                    builder.append(", ");
                    builder.append(this.threshold);
                    if (this.relative_to != Mode.Thread_Calls) break;
                    builder.append(" of ");
                    builder.append((Object)this.relative_to);
                }
            }
            builder.append(")");
            return builder.toString();
        }

        static ThresholdInput of(String raw) {
            return new ThresholdInput(raw);
        }
    }
}

