/*
 * Decompiled with CFR 0.152.
 */
package com.takisoft.preferencex.animation;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.FloatEvaluator;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.annotation.TargetApi;
import android.graphics.Rect;
import android.util.Property;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import androidx.interpolator.view.animation.FastOutSlowInInterpolator;
import com.takisoft.preferencex.animation.PropertyHolder;
import com.takisoft.preferencex.animation.RectEvaluator;
import com.takisoft.preferencex.animation.SimpleMenuBoundsProperty;
import com.takisoft.preferencex.drawable.FixedBoundsDrawable;
import com.takisoft.preferencex.widget.SimpleMenuPopupWindow;

@TargetApi(value=21)
public class SimpleMenuAnimation {
    public static void postStartEnterAnimation(final SimpleMenuPopupWindow popupWindow, final FixedBoundsDrawable background, final int width, final int height, final int startX, final int startY, final Rect start, final int itemHeight, final int elevation, final int selectedIndex) {
        popupWindow.getBackground().setFixedBounds(new Rect());
        popupWindow.getContentView().setClipBounds(new Rect());
        popupWindow.getContentView().post(new Runnable(){

            @Override
            public void run() {
                if (popupWindow.getContentView().getParent() == null) {
                    return;
                }
                SimpleMenuAnimation.startEnterAnimation((View)popupWindow.getContentView(), background, width, height, startX, startY, start, itemHeight, elevation, selectedIndex);
            }
        });
    }

    public static void startEnterAnimation(View view, FixedBoundsDrawable background, int width, int height, int centerX, int centerY, Rect start, int itemHeight, int elevation, int selectedIndex) {
        PropertyHolder holder = new PropertyHolder(background, view);
        Animator backgroundAnimator = SimpleMenuAnimation.createBoundsAnimator(holder, width, height, centerX, centerY, start);
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{backgroundAnimator, SimpleMenuAnimation.createElevationAnimator((View)view.getParent(), elevation)});
        animatorSet.setDuration(backgroundAnimator.getDuration());
        animatorSet.start();
        long delay = 0L;
        if (view instanceof ViewGroup) {
            for (int i = 0; i < ((ViewGroup)view).getChildCount(); ++i) {
                int offset = selectedIndex - i;
                SimpleMenuAnimation.startChild(((ViewGroup)view).getChildAt(i), delay + (long)(30 * Math.abs(offset)), offset == 0 ? 0 : (int)((double)itemHeight * 0.2) * (offset < 0 ? -1 : 1));
            }
        }
    }

    private static void startChild(View child, long delay, int translationY) {
        child.setAlpha(0.0f);
        ObjectAnimator alphaAnimator = ObjectAnimator.ofFloat((Object)child, (String)"alpha", (float[])new float[]{0.0f, 1.0f});
        alphaAnimator.setDuration(200L);
        alphaAnimator.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
        ObjectAnimator translationAnimator = ObjectAnimator.ofFloat((Object)child, (String)"translationY", (float[])new float[]{translationY, 0.0f});
        translationAnimator.setDuration(275L);
        translationAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{alphaAnimator, translationAnimator});
        animatorSet.setStartDelay(delay);
        animatorSet.start();
    }

    private static Rect[] getBounds(int width, int height, int centerX, int centerY) {
        int endWidth = Math.max(centerX, width - centerX);
        int endHeight = Math.max(centerY, height - centerY);
        int endLeft = centerX - endWidth;
        int endRight = centerX + endWidth;
        int endTop = centerY - endHeight;
        int endBottom = centerY + endHeight;
        Rect end = new Rect(endLeft, endTop, endRight, endBottom);
        Rect max = new Rect(0, 0, width, height);
        return new Rect[]{end, max};
    }

    private static Animator createBoundsAnimator(PropertyHolder holder, int width, int height, int centerX, int centerY, Rect start) {
        int speed = 4096;
        int endWidth = Math.max(centerX, width - centerX);
        int endHeight = Math.max(centerY, height - centerY);
        Rect[] rect = SimpleMenuAnimation.getBounds(width, height, centerX, centerY);
        Rect end = rect[0];
        Rect max = rect[1];
        long duration = (long)((float)Math.max(endWidth, endHeight) / (float)speed * 1000.0f);
        duration = Math.max(duration, 150L);
        duration = Math.min(duration, 300L);
        ObjectAnimator animator = ObjectAnimator.ofObject((Object)holder, SimpleMenuBoundsProperty.BOUNDS, (TypeEvaluator)new RectEvaluator(max), (Object[])new Rect[]{start, end});
        animator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        animator.setDuration(duration);
        return animator;
    }

    private static Animator createElevationAnimator(View view, float elevation) {
        ObjectAnimator animator = ObjectAnimator.ofObject((Object)view, (Property)View.TRANSLATION_Z, (TypeEvaluator)new FloatEvaluator(), (Object[])new Float[]{Float.valueOf(-elevation), Float.valueOf(0.0f)});
        animator.setInterpolator((TimeInterpolator)new FastOutSlowInInterpolator());
        return animator;
    }
}

