/*
 * Decompiled with CFR 0.152.
 */
package com.takisoft.preferencex.drawable;

import android.annotation.TargetApi;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Outline;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

@TargetApi(value=21)
public class FixedBoundsDrawable
extends Drawable
implements Drawable.Callback {
    private final Drawable mDrawable;
    private final Rect mFixedBounds = new Rect();

    public FixedBoundsDrawable(Drawable wrappedDrawable) {
        this.mDrawable = wrappedDrawable;
    }

    public Rect getFixedBounds() {
        return this.mFixedBounds;
    }

    public void setFixedBounds(@NonNull Rect bounds) {
        this.setFixedBounds(bounds.left, bounds.top, bounds.right, bounds.bottom);
    }

    public void setFixedBounds(int left, int top, int right, int bottom) {
        this.mFixedBounds.set(left, top, right, bottom);
        this.setBounds(left, top, right, bottom);
    }

    public void getOutline(@NonNull Outline outline) {
        this.mDrawable.getOutline(outline);
    }

    public void draw(@NonNull Canvas canvas) {
        this.mDrawable.setBounds(this.mFixedBounds);
        this.mDrawable.draw(canvas);
    }

    public void setAlpha(int alpha) {
        this.mDrawable.setAlpha(alpha);
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        this.mDrawable.setColorFilter(colorFilter);
    }

    public int getOpacity() {
        return this.mDrawable.getOpacity();
    }

    public void invalidateDrawable(@NonNull Drawable who) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.invalidateDrawable((Drawable)this);
        }
    }

    public void scheduleDrawable(@NonNull Drawable who, @NonNull Runnable what, long when) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.scheduleDrawable((Drawable)this, what, when);
        }
    }

    public void unscheduleDrawable(@NonNull Drawable who, @NonNull Runnable what) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.unscheduleDrawable((Drawable)this, what);
        }
    }
}

