/*
 * Decompiled with CFR 0.152.
 */
package com.talanlabs.avatargenerator.cache;

import com.talanlabs.avatargenerator.IAvatarInfo;
import com.talanlabs.avatargenerator.cache.ICache;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import javax.imageio.ImageIO;

public class FileCache
implements ICache {
    private final Path rootPathDir;

    public FileCache() {
        try {
            this.rootPathDir = Files.createTempDirectory("avatar", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create a temp directory", e);
        }
    }

    public FileCache(Path rootPathDir) {
        this.rootPathDir = rootPathDir;
    }

    @Override
    public BufferedImage get(IAvatarInfo avatarInfo, ICache.ILoader loader) {
        BufferedImage bufferedImage;
        String dir = avatarInfo.getWidth() + "-" + avatarInfo.getHeight() + "-" + avatarInfo.getMargin() + "-" + avatarInfo.getPadding();
        Path pathDir = Paths.get(this.rootPathDir.toString(), dir);
        if (!Files.exists(pathDir, new LinkOption[0])) {
            try {
                Files.createDirectories(pathDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to create directories for " + pathDir.toString(), e);
            }
        }
        String imageName = avatarInfo.getCode() + ".png";
        Path imagePath = Paths.get(pathDir.toString(), imageName);
        if (Files.exists(imagePath, new LinkOption[0])) {
            try {
                bufferedImage = ImageIO.read(imagePath.toFile());
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to read image for " + imagePath.toString(), e);
            }
        }
        bufferedImage = loader.load(avatarInfo);
        try {
            ImageIO.write((RenderedImage)bufferedImage, "png", imagePath.toFile());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write image for " + imagePath.toString(), e);
        }
        return bufferedImage;
    }
}

