/*
 * Decompiled with CFR 0.152.
 */
package com.talanlabs.avatargenerator.layers.shadows;

import com.talanlabs.avatargenerator.IAvatarInfo;
import com.talanlabs.avatargenerator.layers.ILayer;
import com.talanlabs.avatargenerator.utils.AvatarUtils;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;

public abstract class AbstractShadowLayer
implements ILayer {
    private boolean first;

    protected AbstractShadowLayer(boolean first) {
        this.first = first;
    }

    @Override
    public BufferedImage apply(IAvatarInfo avatarInfo, BufferedImage src) {
        BufferedImage dest = new BufferedImage(src.getWidth(), src.getHeight(), 2);
        Graphics2D g2 = dest.createGraphics();
        AvatarUtils.activeAntialiasing(g2);
        if (this.first) {
            g2.drawImage((Image)this.buildShadow(avatarInfo, src), 0, 0, null);
        }
        g2.drawImage((Image)src, 0, 0, null);
        if (!this.first) {
            g2.drawImage((Image)this.buildShadow(avatarInfo, src), 0, 0, null);
        }
        g2.dispose();
        return dest;
    }

    protected abstract BufferedImage buildShadow(IAvatarInfo var1, BufferedImage var2);
}

