/*
 * Decompiled with CFR 0.152.
 */
package com.talanlabs.avatargenerator.utils;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import javax.imageio.ImageIO;

public class AvatarUtils {
    public static List<Color> defaultColors = Arrays.asList(new Color(7216760), new Color(8568320), new Color(10551403), new Color(39590), new Color(13434935), new Color(35022), new Color(14701062), new Color(13970206), new Color(16758290), new Color(13820160));

    private AvatarUtils() {
    }

    public static void activeAntialiasing(Graphics2D g2) {
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
    }

    public static BufferedImage resizeImage(BufferedImage src, int width, int height) {
        int original_width = src.getWidth();
        int original_height = src.getHeight();
        if (original_width == width && original_height == height) {
            return src;
        }
        double diffComponent = (double)width / (double)height;
        double diffImage = (double)original_width / (double)original_height;
        double diff = diffImage / diffComponent;
        int w = width;
        int h = height;
        if (diff >= 1.0) {
            h = (int)((double)h / diff);
        } else {
            w = (int)((double)w * diff);
        }
        BufferedImage dest = new BufferedImage(width, height, 2);
        Graphics2D g2 = dest.createGraphics();
        AvatarUtils.activeAntialiasing(g2);
        g2.drawImage(src.getScaledInstance(w, h, 4), (width - w) / 2, (height - h) / 2, null);
        g2.dispose();
        return dest;
    }

    public static BufferedImage fillColorImage(BufferedImage src, Color color) {
        int original_width = src.getWidth();
        int original_height = src.getHeight();
        BufferedImage dest = new BufferedImage(original_width, original_height, 2);
        Graphics2D g2 = dest.createGraphics();
        g2.setColor(color);
        g2.fillRect(0, 0, original_width, original_height);
        g2.setComposite(AlphaComposite.DstIn);
        g2.drawImage((Image)src, 0, 0, null);
        g2.dispose();
        return dest;
    }

    public static BufferedImage tintImage(BufferedImage src, Color color) {
        int w = src.getWidth();
        int h = src.getHeight();
        BufferedImage dest = new BufferedImage(w, h, 2);
        Graphics2D g = dest.createGraphics();
        g.drawImage((Image)src, 0, 0, null);
        g.setComposite(AlphaComposite.SrcAtop);
        g.setColor(color);
        g.fillRect(0, 0, w, h);
        g.dispose();
        return dest;
    }

    public static BufferedImage planImage(BufferedImage src, int width, int height) {
        int original_width = src.getWidth();
        int original_height = src.getHeight();
        if (original_width == width && original_height == height) {
            return src;
        }
        BufferedImage dest = new BufferedImage(width, height, 2);
        Graphics2D g2 = dest.createGraphics();
        g2.drawImage((Image)src, (width - original_width) / 2, (height - original_height) / 2, null);
        g2.dispose();
        return dest;
    }

    public static Color getComplementColor(Color color, Color blackColor, Color whiteColor) {
        float[] rgba1 = color.getComponents(null);
        double l = 0.2126 * (double)rgba1[0] + 0.7152 * (double)rgba1[1] + 0.0722 * (double)rgba1[2];
        double ratio = (l + 0.05) / 0.05;
        return ratio > 7.0 ? blackColor : whiteColor;
    }

    public static BufferedImage toARGBImage(Image src) {
        BufferedImage dest = new BufferedImage(src.getWidth(null), src.getHeight(null), 2);
        Graphics2D g2 = dest.createGraphics();
        g2.drawImage(src, 0, 0, null);
        g2.dispose();
        return dest;
    }

    public static Path saveImageInTemp(BufferedImage src) {
        try {
            Path path = Files.createTempFile("image", ".png", new FileAttribute[0]);
            ImageIO.write((RenderedImage)src, "png", path.toFile());
            return path;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to save image", e);
        }
    }

    private static String addZeroes(String ns, int nd) {
        for (int i = 0; i < nd - ns.length(); ++i) {
            ns = "0" + ns;
        }
        return ns;
    }

    public static Color extractColor(long code) {
        String n = AvatarUtils.addZeroes(Long.toHexString(code), 6);
        return new Color(Integer.parseInt(n.substring(0, 6), 16));
    }

    public static float getColorDistance(Color c1, Color c2) {
        float dx = c1.getRed() - c2.getRed();
        float dy = c1.getGreen() - c2.getGreen();
        float dz = c1.getBlue() - c2.getBlue();
        return (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public static Color getComplementaryColor(Color color) {
        return new Color(color.getRGB() ^ 0xFFFFFF);
    }
}

