/*
 * Decompiled with CFR 0.152.
 */
package com.tambapps.http.hyperpoet;

import com.tambapps.http.hyperpoet.ContentType;
import com.tambapps.http.hyperpoet.HttpPoem;
import com.tambapps.http.hyperpoet.HttpPoet;
import groovy.lang.Closure;
import groovy.transform.NamedParam;
import groovy.transform.NamedParams;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class HttpHaiku {
    private static final AtomicReference<HttpPoet> POET_REFERENCE = new AtomicReference();

    public static HttpPoet getPoet() {
        return POET_REFERENCE.updateAndGet(p -> p != null ? p : new HttpPoet());
    }

    public static HttpPoem toPoem() {
        return HttpHaiku.getPoet().poem();
    }

    public static Object get(String url) throws IOException {
        return HttpHaiku.get(url, Collections.emptyMap());
    }

    public static Object get(String url, Map queryParams) throws IOException {
        return HttpHaiku.get(Collections.singletonMap("params", queryParams), url);
    }

    public static Object get(@NamedParams(value={@NamedParam(value="body"), @NamedParam(value="contentType", type=ContentType.class), @NamedParam(value="composer", type=Closure.class), @NamedParam(value="parser", type=Closure.class), @NamedParam(value="params", type=Map.class), @NamedParam(value="headers", type=Map.class), @NamedParam(value="acceptContentType", type=ContentType.class), @NamedParam(value="skipHistory", type=Boolean.class)}) Map<?, ?> additionalParameters, String url) throws IOException {
        return HttpHaiku.getPoet().get(additionalParameters, url);
    }

    public static Object delete(String url) throws IOException {
        return HttpHaiku.delete(url, Collections.emptyMap());
    }

    public static Object delete(String url, Map queryParams) throws IOException {
        return HttpHaiku.delete(Collections.singletonMap("params", queryParams), url);
    }

    public static Object delete(@NamedParams(value={@NamedParam(value="body"), @NamedParam(value="contentType", type=ContentType.class), @NamedParam(value="composer", type=Closure.class), @NamedParam(value="parser", type=Closure.class), @NamedParam(value="params", type=Map.class), @NamedParam(value="headers", type=Map.class), @NamedParam(value="acceptContentType", type=ContentType.class), @NamedParam(value="skipHistory", type=Boolean.class)}) Map<?, ?> additionalParameters, String url) throws IOException {
        return HttpHaiku.getPoet().delete(additionalParameters, url);
    }

    public static Object post(String url, Map body) throws IOException {
        return HttpHaiku.post(Collections.singletonMap("body", body), url);
    }

    public static Object post(String url, Map body, ContentType contentType) throws IOException {
        HashMap map = new HashMap();
        map.put("body", body);
        map.put("contentType", contentType);
        return HttpHaiku.post(map, url);
    }

    public static Object post(@NamedParams(value={@NamedParam(value="body"), @NamedParam(value="contentType", type=ContentType.class), @NamedParam(value="composer", type=Closure.class), @NamedParam(value="parser", type=Closure.class), @NamedParam(value="params", type=Map.class), @NamedParam(value="headers", type=Map.class), @NamedParam(value="acceptContentType", type=ContentType.class), @NamedParam(value="skipHistory", type=Boolean.class)}) Map<?, ?> additionalParameters, String url) throws IOException {
        return HttpHaiku.getPoet().post(additionalParameters, url);
    }

    public static Object patch(String url, Map body) throws IOException {
        return HttpHaiku.patch(Collections.singletonMap("body", body), url);
    }

    public static Object patch(String url, Map body, ContentType contentType) throws IOException {
        HashMap map = new HashMap();
        map.put("body", body);
        map.put("contentType", contentType);
        return HttpHaiku.patch(map, url);
    }

    public static Object patch(@NamedParams(value={@NamedParam(value="body"), @NamedParam(value="contentType", type=ContentType.class), @NamedParam(value="composer", type=Closure.class), @NamedParam(value="parser", type=Closure.class), @NamedParam(value="params", type=Map.class), @NamedParam(value="headers", type=Map.class), @NamedParam(value="acceptContentType", type=ContentType.class), @NamedParam(value="skipHistory", type=Boolean.class)}) Map<?, ?> additionalParameters, String url) throws IOException {
        return HttpHaiku.getPoet().patch(additionalParameters, url);
    }

    public static Object put(String url, Map body) throws IOException {
        return HttpHaiku.put(Collections.singletonMap("body", body), url);
    }

    public static Object put(String url, Map body, ContentType contentType) throws IOException {
        HashMap map = new HashMap();
        map.put("body", body);
        map.put("contentType", contentType);
        return HttpHaiku.put(map, url);
    }

    public static Object put(@NamedParams(value={@NamedParam(value="body"), @NamedParam(value="contentType", type=ContentType.class), @NamedParam(value="composer", type=Closure.class), @NamedParam(value="parser", type=Closure.class), @NamedParam(value="params", type=Map.class), @NamedParam(value="headers", type=Map.class), @NamedParam(value="acceptContentType", type=ContentType.class), @NamedParam(value="skipHistory", type=Boolean.class)}) Map<?, ?> additionalParameters, String url) throws IOException {
        return HttpHaiku.getPoet().put(additionalParameters, url);
    }
}

