/*
 * Decompiled with CFR 0.152.
 */
package com.tambapps.http.hyperpoet;

import com.tambapps.http.hyperpoet.ContentType;
import com.tambapps.http.hyperpoet.History;
import com.tambapps.http.hyperpoet.HttpMethod;
import com.tambapps.http.hyperpoet.HttpPoet;
import com.tambapps.http.hyperpoet.url.UrlBuilder;
import groovy.lang.Closure;
import groovy.lang.GroovyObjectSupport;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class HttpPoem
extends GroovyObjectSupport {
    private HttpPoet poet;

    public Object run(Closure closure) {
        closure.setDelegate((Object)this);
        return closure.call();
    }

    public Object get(Map<?, ?> body, String url, Object ... params) throws IOException {
        Object[] realParams = new Object[params.length + 1];
        System.arraycopy(params, 0, realParams, 1, params.length);
        realParams[0] = this.params(body);
        return this.get(url, realParams);
    }

    public Object get(String url, Object ... params) throws IOException {
        return this.poet.get(this.buildPoetParams(HttpMethod.GET, params), url);
    }

    public Object delete(Map<?, ?> body, String url, Object ... params) throws IOException {
        Object[] realParams = new Object[params.length + 1];
        System.arraycopy(params, 0, realParams, 1, params.length);
        realParams[0] = this.params(body);
        return this.get(url, realParams);
    }

    public Object delete(String url, Object ... params) throws IOException {
        return this.poet.delete(this.buildPoetParams(HttpMethod.DELETE, params), url);
    }

    public Object patch(Map<?, ?> body, String url, Object ... params) throws IOException {
        Object[] realParams = new Object[params.length + 1];
        System.arraycopy(params, 0, realParams, 1, params.length);
        realParams[0] = this.body(body);
        return this.patch(url, realParams);
    }

    public Object patch(String url, Object ... params) throws IOException {
        return this.poet.patch(this.buildPoetParams(HttpMethod.PATCH, params), url);
    }

    public Object put(String url, Object ... params) throws IOException {
        return this.poet.put(this.buildPoetParams(HttpMethod.PUT, params), url);
    }

    public Object put(Map<?, ?> body, String url, Object ... params) throws IOException {
        Object[] realParams = new Object[params.length + 1];
        System.arraycopy(params, 0, realParams, 1, params.length);
        realParams[0] = this.body(body);
        return this.put(url, realParams);
    }

    public Object post(String url, Object ... params) throws IOException {
        return this.poet.post(this.buildPoetParams(HttpMethod.POST, params), url);
    }

    public Object post(Map<?, ?> body, String url, Object ... params) throws IOException {
        Object[] realParams = new Object[params.length + 1];
        System.arraycopy(params, 0, realParams, 1, params.length);
        realParams[0] = this.body(body);
        return this.post(url, realParams);
    }

    public String path(String path) {
        return this.path(Collections.emptyMap(), path);
    }

    public String path(Map<?, ?> queryParams, String path) {
        return this.url(queryParams, path);
    }

    public String url(String url) {
        return this.url(Collections.emptyMap(), url);
    }

    public String url(Map<?, ?> queryParams, String url) {
        return new UrlBuilder(url).addParams(queryParams).build();
    }

    public Map<?, ?> b(Map<?, ?> params) {
        return this.body(params, null);
    }

    public Map<?, ?> body(Map<?, ?> params) {
        return this.body(params, null);
    }

    public Map<?, ?> b(Map<?, ?> params, ContentType contentType) {
        return this.body(params, contentType);
    }

    public Map<?, ?> body(Map<?, ?> params, ContentType contentType) {
        return new BodyMap(params, contentType);
    }

    public Map<?, ?> h(Map<?, ?> params) {
        return this.headers(params);
    }

    public Map<?, ?> headers(Map<?, ?> params) {
        return new HeaderMap(params);
    }

    public Map<?, ?> p(Map<?, ?> params) {
        return this.params(params);
    }

    public Map<?, ?> params(Map<?, ?> params) {
        return new ParamMap(params);
    }

    public Map<?, ?> a(Map<?, ?> params) {
        return this.additionalParameters(params);
    }

    public Map<?, ?> additionalParameters(Map<?, ?> params) {
        return new AdditionalParametersMap(params);
    }

    private Map<?, ?> buildPoetParams(HttpMethod method, Object ... params) {
        return this.buildPoetParams(method.name(), params);
    }

    private Map<?, ?> buildPoetParams(String method, Object ... params) {
        Optional<BodyMap> optBody = Optional.empty();
        Optional<ParamMap> optParams = Optional.empty();
        Optional<HeaderMap> optHeaders = Optional.empty();
        Optional<AdditionalParametersMap> optAdditionalParametersMap = Optional.empty();
        HashMap<String, Object> poetParams = new HashMap<String, Object>();
        boolean requiresRequestBody = method != null && okhttp3.internal.http.HttpMethod.requiresRequestBody((String)method);
        for (Object param : params) {
            if (param instanceof BodyMap) {
                optBody = Optional.of((BodyMap)param);
                continue;
            }
            if (param instanceof ParamMap) {
                optParams = Optional.of((ParamMap)param);
                continue;
            }
            if (param instanceof HeaderMap) {
                optHeaders = Optional.of((HeaderMap)param);
                continue;
            }
            if (param instanceof AdditionalParametersMap) {
                optAdditionalParametersMap = Optional.of((AdditionalParametersMap)param);
                continue;
            }
            if (param instanceof ContentType) {
                poetParams.put(requiresRequestBody ? "contentType" : "acceptContentType", param);
                continue;
            }
            if (params.length != 1) {
                throw new RuntimeException("Don't know how to handle provided parameters");
            }
            if (requiresRequestBody) {
                poetParams.put("body", params[0]);
                continue;
            }
            poetParams.put("params", params[0]);
        }
        optBody.ifPresent(body -> {
            poetParams.put("body", body);
            if (body.getContentType() != null) {
                poetParams.put("contentType", body.getContentType());
            }
        });
        optParams.ifPresent(queryParams -> poetParams.put("params", queryParams));
        optHeaders.ifPresent(headers -> poetParams.put("headers", headers));
        optAdditionalParametersMap.ifPresent(poetParams::putAll);
        return poetParams;
    }

    public History getHistory() {
        return this.poet.getHistory();
    }

    public HttpPoem(HttpPoet poet) {
        this.poet = poet;
    }

    public HttpPoet getPoet() {
        return this.poet;
    }

    public void setPoet(HttpPoet poet) {
        this.poet = poet;
    }

    private static class AdditionalParametersMap
    extends HashMap<Object, Object> {
        public AdditionalParametersMap(Map<?, ?> m) {
            super(m);
        }
    }

    private static class HeaderMap
    extends HashMap<Object, Object> {
        public HeaderMap(Map<?, ?> m) {
            super(m);
        }
    }

    private static class ParamMap
    extends HashMap<Object, Object> {
        public ParamMap(Map<?, ?> m) {
            super(m);
        }
    }

    private static class BodyMap
    extends HashMap<Object, Object> {
        private final ContentType contentType;

        public BodyMap(Map<?, ?> m, ContentType contentType) {
            super(m);
            this.contentType = contentType;
        }

        public ContentType getContentType() {
            return this.contentType;
        }
    }
}

