/*
 * Decompiled with CFR 0.152.
 */
package com.tambapps.http.hyperpoet;

import com.tambapps.http.hyperpoet.AbstractHttpPoet;
import com.tambapps.http.hyperpoet.ContentType;
import com.tambapps.http.hyperpoet.ErrorResponseException;
import com.tambapps.http.hyperpoet.HttpMethod;
import com.tambapps.http.hyperpoet.HttpPoem;
import com.tambapps.http.hyperpoet.invoke.PoeticInvoker;
import com.tambapps.http.hyperpoet.util.ParametersUtils;
import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.MissingMethodException;
import groovy.transform.NamedParam;
import groovy.transform.NamedParams;
import groovy.transform.stc.ClosureParams;
import groovy.transform.stc.SimpleType;
import java.beans.Transient;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.codehaus.groovy.runtime.InvokerHelper;

public class HttpPoet
extends AbstractHttpPoet
implements GroovyObject {
    public static final int DEFAULT_HISTORY_LIMIT = 10;
    private transient MetaClass metaClass = this.getDefaultMetaClass();
    private PoeticInvoker poeticInvoker = null;

    public HttpPoet() {
        this("");
    }

    public HttpPoet(OkHttpClient client) {
        this(client, "");
    }

    public HttpPoet(@NamedParams(value={@NamedParam(value="okHttpClient", type=OkHttpClient.class), @NamedParam(value="url", type=String.class), @NamedParam(value="headers", type=Map.class), @NamedParam(value="errorResponseHandler", type=Closure.class), @NamedParam(value="onPreExecute", type=Closure.class), @NamedParam(value="onPostExecute", type=Closure.class), @NamedParam(value="acceptContentType", type=Closure.class), @NamedParam(value="contentType", type=Closure.class)}) Map<?, ?> properties) {
        this((OkHttpClient)ParametersUtils.getOrDefaultSupply(properties, (String)"okHttpClient", OkHttpClient.class, OkHttpClient::new), ParametersUtils.getStringOrDefault(properties, (String)"url", (String)""));
        Map headers = (Map)ParametersUtils.getOrDefault(properties, (String)"headers", Map.class, Collections.emptyMap());
        for (Map.Entry entry : headers.entrySet()) {
            this.putHeader(entry.getKey(), entry.getValue());
        }
        this.setErrorResponseHandler(this.getFunctionOrDefault(properties, "errorResponseHandler", this.getErrorResponseHandler()));
        this.onPreExecute = this.getFunctionOrDefault(properties, "onPreExecute", null);
        this.onPostExecute = this.getFunctionOrDefault(properties, "onPostExecute", null);
        this.setAcceptContentType((ContentType)ParametersUtils.getOrDefault(properties, (String)"acceptContentType", ContentType.class, null));
        this.setContentType((ContentType)ParametersUtils.getOrDefault(properties, (String)"contentType", ContentType.class, null));
    }

    public HttpPoet(String baseUrl) {
        this(new OkHttpClient(), baseUrl);
    }

    public HttpPoet(OkHttpClient okHttpClient, String baseUrl) {
        super(okHttpClient, baseUrl);
    }

    public Object method(String urlOrEndpoint, HttpMethod method) throws IOException {
        return this.method(urlOrEndpoint, method.toString());
    }

    public Object method(String urlOrEndpoint, String method) throws IOException {
        return this.method(Collections.emptyMap(), urlOrEndpoint, method);
    }

    public Object method(@NamedParams(value={@NamedParam(value="body"), @NamedParam(value="contentType", type=ContentType.class), @NamedParam(value="composer", type=Closure.class), @NamedParam(value="parser", type=Closure.class), @NamedParam(value="params", type=Map.class), @NamedParam(value="headers", type=Map.class), @NamedParam(value="acceptContentType", type=ContentType.class), @NamedParam(value="skipHistory", type=Boolean.class)}) Map<?, ?> additionalParameters, String urlOrEndpoint, HttpMethod method) throws IOException {
        return this.method(additionalParameters, urlOrEndpoint, method.name());
    }

    public Object method(@NamedParams(value={@NamedParam(value="body"), @NamedParam(value="contentType", type=ContentType.class), @NamedParam(value="composer", type=Closure.class), @NamedParam(value="parser", type=Closure.class), @NamedParam(value="params", type=Map.class), @NamedParam(value="headers", type=Map.class), @NamedParam(value="acceptContentType", type=ContentType.class), @NamedParam(value="skipHistory", type=Boolean.class)}) Map<?, ?> additionalParameters, String urlOrEndpoint, String method) throws IOException {
        Request request = this.request(method, urlOrEndpoint, additionalParameters);
        return this.doRequest(request, additionalParameters);
    }

    public Object method(String urlOrEndpoint, String method, @ClosureParams(value=SimpleType.class, options={"okhttp3.Response"}) Function responseHandler) throws IOException {
        return this.method(Collections.emptyMap(), urlOrEndpoint, method, responseHandler);
    }

    public Object method(@NamedParams(value={@NamedParam(value="body"), @NamedParam(value="contentType", type=ContentType.class), @NamedParam(value="composer", type=Closure.class), @NamedParam(value="parser", type=Closure.class), @NamedParam(value="params", type=Map.class), @NamedParam(value="headers", type=Map.class), @NamedParam(value="acceptContentType", type=ContentType.class), @NamedParam(value="skipHistory", type=Boolean.class)}) Map<?, ?> additionalParameters, String urlOrEndpoint, HttpMethod method, @ClosureParams(value=SimpleType.class, options={"okhttp3.Response"}) Function responseHandler) throws IOException {
        return this.method(additionalParameters, urlOrEndpoint, method.name(), responseHandler);
    }

    public Object method(@NamedParams(value={@NamedParam(value="body"), @NamedParam(value="contentType", type=ContentType.class), @NamedParam(value="composer", type=Closure.class), @NamedParam(value="parser", type=Closure.class), @NamedParam(value="params", type=Map.class), @NamedParam(value="headers", type=Map.class), @NamedParam(value="acceptContentType", type=ContentType.class), @NamedParam(value="skipHistory", type=Boolean.class)}) Map<?, ?> additionalParameters, String urlOrEndpoint, String method, @ClosureParams(value=SimpleType.class, options={"okhttp3.Response"}) Function responseHandler) throws IOException {
        Request request = this.request(method, urlOrEndpoint, additionalParameters);
        return this.doRequest(request, additionalParameters, responseHandler);
    }

    public Object put(String urlOrEndpoint) throws IOException {
        return this.put(Collections.emptyMap(), urlOrEndpoint);
    }

    public Object put(@NamedParams(value={@NamedParam(value="body"), @NamedParam(value="contentType", type=ContentType.class), @NamedParam(value="composer", type=Closure.class), @NamedParam(value="parser", type=Closure.class), @NamedParam(value="params", type=Map.class), @NamedParam(value="headers", type=Map.class), @NamedParam(value="acceptContentType", type=ContentType.class), @NamedParam(value="skipHistory", type=Boolean.class)}) Map<?, ?> additionalParameters, String urlOrEndpoint) throws IOException {
        return this.method(additionalParameters, urlOrEndpoint, HttpMethod.PUT);
    }

    public Object put(String urlOrEndpoint, @ClosureParams(value=SimpleType.class, options={"okhttp3.Response"}) Function responseHandler) throws IOException {
        return this.put(Collections.emptyMap(), urlOrEndpoint, responseHandler);
    }

    public Object put(@NamedParams(value={@NamedParam(value="body"), @NamedParam(value="contentType", type=ContentType.class), @NamedParam(value="composer", type=Closure.class), @NamedParam(value="parser", type=Closure.class), @NamedParam(value="params", type=Map.class), @NamedParam(value="headers", type=Map.class), @NamedParam(value="acceptContentType", type=ContentType.class)}) Map<?, ?> additionalParameters, String urlOrEndpoint, @ClosureParams(value=SimpleType.class, options={"okhttp3.Response"}) Function responseHandler) throws IOException {
        return this.method(additionalParameters, urlOrEndpoint, HttpMethod.PUT, responseHandler);
    }

    public Object patch(String urlOrEndpoint) throws IOException {
        return this.patch(Collections.emptyMap(), urlOrEndpoint);
    }

    public Object patch(@NamedParams(value={@NamedParam(value="body"), @NamedParam(value="contentType", type=ContentType.class), @NamedParam(value="composer", type=Closure.class), @NamedParam(value="parser", type=Closure.class), @NamedParam(value="params", type=Map.class), @NamedParam(value="headers", type=Map.class), @NamedParam(value="acceptContentType", type=ContentType.class), @NamedParam(value="skipHistory", type=Boolean.class)}) Map<?, ?> additionalParameters, String urlOrEndpoint) throws IOException {
        return this.method(additionalParameters, urlOrEndpoint, HttpMethod.PATCH);
    }

    public Object patch(String urlOrEndpoint, @ClosureParams(value=SimpleType.class, options={"okhttp3.Response"}) Function responseHandler) throws IOException {
        return this.post(Collections.emptyMap(), urlOrEndpoint, responseHandler);
    }

    public Object patch(@NamedParams(value={@NamedParam(value="body"), @NamedParam(value="contentType", type=ContentType.class), @NamedParam(value="composer", type=Closure.class), @NamedParam(value="parser", type=Closure.class), @NamedParam(value="params", type=Map.class), @NamedParam(value="headers", type=Map.class), @NamedParam(value="acceptContentType", type=ContentType.class), @NamedParam(value="skipHistory", type=Boolean.class)}) Map<?, ?> additionalParameters, String urlOrEndpoint, @ClosureParams(value=SimpleType.class, options={"okhttp3.Response"}) Function responseHandler) throws IOException {
        return this.method(additionalParameters, urlOrEndpoint, HttpMethod.PATCH, responseHandler);
    }

    public Object post(String urlOrEndpoint) throws IOException {
        return this.post(Collections.emptyMap(), urlOrEndpoint);
    }

    public Object post(@NamedParams(value={@NamedParam(value="body"), @NamedParam(value="contentType", type=ContentType.class), @NamedParam(value="composer", type=Closure.class), @NamedParam(value="parser", type=Closure.class), @NamedParam(value="params", type=Map.class), @NamedParam(value="headers", type=Map.class), @NamedParam(value="acceptContentType", type=ContentType.class), @NamedParam(value="skipHistory", type=Boolean.class)}) Map<?, ?> additionalParameters, String urlOrEndpoint) throws IOException {
        return this.method(additionalParameters, urlOrEndpoint, HttpMethod.POST);
    }

    public Object post(String urlOrEndpoint, @ClosureParams(value=SimpleType.class, options={"okhttp3.Response"}) Function responseHandler) throws IOException {
        return this.post(Collections.emptyMap(), urlOrEndpoint, responseHandler);
    }

    public Object post(@NamedParams(value={@NamedParam(value="body"), @NamedParam(value="contentType", type=ContentType.class), @NamedParam(value="composer", type=Closure.class), @NamedParam(value="parser", type=Closure.class), @NamedParam(value="params", type=Map.class), @NamedParam(value="headers", type=Map.class), @NamedParam(value="acceptContentType", type=ContentType.class), @NamedParam(value="skipHistory", type=Boolean.class)}) Map<?, ?> additionalParameters, String urlOrEndpoint, @ClosureParams(value=SimpleType.class, options={"okhttp3.Response"}) Function responseHandler) throws IOException {
        return this.method(additionalParameters, urlOrEndpoint, HttpMethod.POST, responseHandler);
    }

    public Object delete(String urlOrEndpoint) throws IOException {
        return this.delete(Collections.emptyMap(), urlOrEndpoint);
    }

    public Object delete(@NamedParams(value={@NamedParam(value="body"), @NamedParam(value="contentType", type=ContentType.class), @NamedParam(value="composer", type=Closure.class), @NamedParam(value="parser", type=Closure.class), @NamedParam(value="params", type=Map.class), @NamedParam(value="headers", type=Map.class), @NamedParam(value="acceptContentType", type=ContentType.class), @NamedParam(value="skipHistory", type=Boolean.class)}) Map<?, ?> additionalParameters, String urlOrEndpoint) throws IOException {
        Request request = this.request(HttpMethod.DELETE, urlOrEndpoint, additionalParameters);
        return this.doRequest(request, additionalParameters);
    }

    public Object delete(String urlOrEndpoint, @ClosureParams(value=SimpleType.class, options={"okhttp3.Response"}) Function responseHandler) throws IOException {
        return this.delete(Collections.emptyMap(), urlOrEndpoint, responseHandler);
    }

    public Object delete(@NamedParams(value={@NamedParam(value="body"), @NamedParam(value="contentType", type=ContentType.class), @NamedParam(value="composer", type=Closure.class), @NamedParam(value="parser", type=Closure.class), @NamedParam(value="params", type=Map.class), @NamedParam(value="headers", type=Map.class), @NamedParam(value="acceptContentType", type=ContentType.class), @NamedParam(value="skipHistory", type=Boolean.class)}) Map<?, ?> additionalParameters, String urlOrEndpoint, @ClosureParams(value=SimpleType.class, options={"okhttp3.Response"}) Function responseHandler) throws IOException {
        Request request = this.request(HttpMethod.DELETE, urlOrEndpoint, additionalParameters);
        return this.doRequest(request, additionalParameters, responseHandler);
    }

    public Object get(String urlOrEndpoint) throws IOException {
        return this.get(Collections.emptyMap(), urlOrEndpoint);
    }

    public Object get(@NamedParams(value={@NamedParam(value="body"), @NamedParam(value="contentType", type=ContentType.class), @NamedParam(value="composer", type=Closure.class), @NamedParam(value="parser", type=Closure.class), @NamedParam(value="params", type=Map.class), @NamedParam(value="headers", type=Map.class), @NamedParam(value="acceptContentType", type=ContentType.class), @NamedParam(value="skipHistory", type=Boolean.class)}) Map<?, ?> additionalParameters, String urlOrEndpoint) throws IOException {
        Request request = this.request(HttpMethod.GET, urlOrEndpoint, additionalParameters);
        return this.doRequest(request, additionalParameters);
    }

    public Object get(String urlOrEndpoint, @ClosureParams(value=SimpleType.class, options={"okhttp3.Response"}) Function responseHandler) throws IOException {
        return this.get(Collections.emptyMap(), urlOrEndpoint, responseHandler);
    }

    public Object get(@NamedParams(value={@NamedParam(value="body"), @NamedParam(value="contentType", type=ContentType.class), @NamedParam(value="composer", type=Closure.class), @NamedParam(value="parser", type=Closure.class), @NamedParam(value="params", type=Map.class), @NamedParam(value="headers", type=Map.class), @NamedParam(value="acceptContentType", type=ContentType.class), @NamedParam(value="skipHistory", type=Boolean.class)}) Map<?, ?> additionalParameters, String urlOrEndpoint, @ClosureParams(value=SimpleType.class, options={"okhttp3.Response"}) Function<Object, ?> responseHandler) throws IOException {
        Request request = this.request(HttpMethod.GET, urlOrEndpoint, additionalParameters);
        return this.doRequest(request, additionalParameters, responseHandler);
    }

    private Object doRequest(Request request, Map<?, ?> additionalParameters, Function<Object, ?> responseHandler) throws IOException {
        ContentType acceptContentType = (ContentType)ParametersUtils.getOrDefault(additionalParameters, (String)"acceptContentType", ContentType.class, (Object)this.getAcceptContentType());
        return super.doRequest(request, ParametersUtils.getOrDefault(additionalParameters, (String)"body", Object.class, null), ((Boolean)ParametersUtils.getOrDefault(additionalParameters, (String)"skipHistory", Boolean.class, (Object)false)).booleanValue(), (ContentType)ParametersUtils.getOrDefault(additionalParameters, (String)"acceptContentType", ContentType.class, (Object)acceptContentType), this.getFunctionOrDefault(additionalParameters, "parser", null), responseHandler);
    }

    protected Object doRequest(Request request, Map<?, ?> additionalParameters) throws IOException {
        ContentType acceptContentType = (ContentType)ParametersUtils.getOrDefault(additionalParameters, (String)"acceptContentType", ContentType.class, (Object)this.getAcceptContentType());
        return super.doRequest(request, ParametersUtils.getOrDefault(additionalParameters, (String)"body", Object.class, null), (Boolean)ParametersUtils.getOrDefault(additionalParameters, (String)"skipHistory", Boolean.class, (Object)false), (Boolean)ParametersUtils.getOrDefault(additionalParameters, (String)"print", Boolean.class, (Object)true), (Boolean)ParametersUtils.getOrDefault(additionalParameters, (String)"printRequestBody", Boolean.class, (Object)true), (Boolean)ParametersUtils.getOrDefault(additionalParameters, (String)"printResponseBody", Boolean.class, (Object)true), (ContentType)ParametersUtils.getOrDefault(additionalParameters, (String)"acceptContentType", ContentType.class, (Object)acceptContentType), this.getFunctionOrDefault(additionalParameters, "parser", null));
    }

    private Function<Object, ?> getFunctionOrDefault(Map<?, ?> additionalParameters, String key, Function<Object, ?> defaultValue) {
        if (additionalParameters.get(key) instanceof Closure) {
            Closure closure = (Closure)additionalParameters.get(key);
            return arg_0 -> ((Closure)closure).call(arg_0);
        }
        return (Function)ParametersUtils.getOrDefault(additionalParameters, (String)key, Function.class, defaultValue);
    }

    protected Object handleResponse(Response response, Map<?, ?> additionalParameters) {
        if (!response.isSuccessful()) {
            return this.handleErrorResponse(response, additionalParameters);
        }
        return this.parseResponse(response, additionalParameters);
    }

    protected Object parseResponse(Response response, Map<?, ?> additionalParameters) {
        ContentType responseContentType = this.extractResponseContentType(response, additionalParameters);
        return super.parseResponse(response, responseContentType, this.getFunctionOrDefault(additionalParameters, "parser", null));
    }

    private ContentType extractResponseContentType(Response response, Map<?, ?> additionalParameters) {
        return (ContentType)ParametersUtils.getOrDefaultSupply(additionalParameters, (String)"acceptContentType", ContentType.class, () -> this.getResponseContentType(response));
    }

    public Request request(HttpMethod method, String urlOrEndpoint, Map<?, ?> additionalParameters) throws IOException {
        return this.request(method.name(), urlOrEndpoint, additionalParameters);
    }

    public Request request(String method, String urlOrEndpoint, Map<?, ?> additionalParameters) throws IOException {
        return super.request(method, urlOrEndpoint, (Map)ParametersUtils.getOrDefault(additionalParameters, (String)"params", Map.class, null), (ContentType)ParametersUtils.getOrDefault(additionalParameters, (String)"contentType", ContentType.class, (Object)this.getContentType()), ParametersUtils.getOrDefault(additionalParameters, (String)"body", Object.class, null), this.getFunctionOrDefault(additionalParameters, "composer", null), (Map)ParametersUtils.getOrDefault(additionalParameters, (String)"headers", Map.class, Collections.emptyMap()), (ContentType)ParametersUtils.getOrDefault(additionalParameters, (String)"acceptContentType", ContentType.class, (Object)this.getAcceptContentType()));
    }

    protected Object handleErrorResponse(Response response, Map<?, ?> additionalParameters) {
        if (this.getErrorResponseHandler() != null) {
            return this.getErrorResponseHandler().apply(response);
        }
        return this.defaultHandleErrorResponse(response, additionalParameters);
    }

    protected Object defaultHandleErrorResponse(Response response, Map<?, ?> additionalParameters) {
        ErrorResponseException exception = ErrorResponseException.from((Response)response);
        response.close();
        throw exception;
    }

    public Object invokeMethod(String name, Object args) {
        try {
            return this.getMetaClass().invokeMethod((Object)this, name, args);
        }
        catch (MissingMethodException e) {
            Object[] objectArray;
            if (this.getPoeticInvoker() == null) {
                throw e;
            }
            PoeticInvoker poeticInvoker = this.getPoeticInvoker();
            if (args instanceof Object[]) {
                objectArray = (Object[])args;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = args;
            }
            return poeticInvoker.invokeOrThrow(this, name, objectArray, e);
        }
    }

    public void addInterceptor(@ClosureParams(value=SimpleType.class, options={"okhttp3.Interceptor.Chain"}) Closure<Response> interceptor) {
        this.addInterceptor(arg_0 -> interceptor.call(arg_0));
    }

    public void addNetworkInterceptor(@ClosureParams(value=SimpleType.class, options={"okhttp3.Interceptor.Chain"}) Closure<Response> interceptor) {
        this.addNetworkInterceptor(arg_0 -> interceptor.call(arg_0));
    }

    public HttpPoem poem() {
        return new HttpPoem(this);
    }

    public Object poem(@DelegatesTo(value=HttpPoem.class) Closure closure) {
        return new HttpPoem(this).run(closure);
    }

    protected RequestBody requestBody(Object body, Function composerOverride, ContentType contentType, String method) throws IOException {
        if (body instanceof Closure) {
            body = ((Closure)body).call();
        }
        return super.requestBody(body, composerOverride, contentType, method);
    }

    @Transient
    public MetaClass getMetaClass() {
        return this.metaClass;
    }

    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = Optional.ofNullable(metaClass).orElseGet(this::getDefaultMetaClass);
    }

    private MetaClass getDefaultMetaClass() {
        return InvokerHelper.getMetaClass(((Object)((Object)this)).getClass());
    }

    public PoeticInvoker getPoeticInvoker() {
        return this.poeticInvoker;
    }

    public void setPoeticInvoker(PoeticInvoker poeticInvoker) {
        this.poeticInvoker = poeticInvoker;
    }
}

