/*
 * Decompiled with CFR 0.152.
 */
package com.tambapps.http.hyperpoet.invoke;

import com.atlassian.oai.validator.OpenApiInteractionValidator;
import com.atlassian.oai.validator.model.Request;
import com.atlassian.oai.validator.model.SimpleRequest;
import com.atlassian.oai.validator.report.ValidationReport;
import com.tambapps.http.hyperpoet.HttpMethod;
import com.tambapps.http.hyperpoet.HttpPoet;
import com.tambapps.http.hyperpoet.invoke.PoeticInvoker;
import groovy.lang.MissingMethodException;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.parser.OpenAPIV3Parser;
import io.swagger.v3.parser.core.models.ParseOptions;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;
import org.codehaus.groovy.runtime.IOGroovyMethods;

public class OpenApiSpecPoeticInvoker
implements PoeticInvoker<HttpPoet> {
    private static final Pattern PATH_VARIABLE_PATTERN = Pattern.compile("\\{\\w+}");
    private final Map<String, EndpointOperation> endpointOperationMap;
    private final OpenApiInteractionValidator validator;

    public static OpenApiSpecPoeticInvoker fromSpec(File file) throws IOException {
        return OpenApiSpecPoeticInvoker.fromSpec(new FileInputStream(file));
    }

    public static OpenApiSpecPoeticInvoker fromSpec(InputStream inputStream) throws IOException {
        return OpenApiSpecPoeticInvoker.fromSpec(IOGroovyMethods.getText((InputStream)inputStream));
    }

    public static OpenApiSpecPoeticInvoker fromSpec(String spec) throws IOException {
        ParseOptions parseOptions = new ParseOptions();
        parseOptions.setResolve(true);
        parseOptions.setResolveFully(true);
        SwaggerParseResult result = new OpenAPIV3Parser().readContents(spec, null, parseOptions);
        if (result.getMessages() != null && !result.getMessages().isEmpty()) {
            throw new IOException("Error while parsing spec: " + String.join((CharSequence)", ", result.getMessages()));
        }
        return OpenApiSpecPoeticInvoker.fromSpec(result.getOpenAPI());
    }

    public static OpenApiSpecPoeticInvoker fromSpec(OpenAPI openAPI) {
        return OpenApiSpecPoeticInvoker.fromSpec(openAPI, OpenApiInteractionValidator.createFor((OpenAPI)openAPI).build());
    }

    public static OpenApiSpecPoeticInvoker fromSpec(OpenAPI openAPI, OpenApiInteractionValidator validator) {
        HashMap<String, EndpointOperation> endpointOperationMap = new HashMap<String, EndpointOperation>();
        for (Map.Entry entry : openAPI.getPaths().entrySet()) {
            String path = (String)entry.getKey();
            PathItem item = (PathItem)entry.getValue();
            OpenApiSpecPoeticInvoker.addOperation(endpointOperationMap, path, item.getGet(), HttpMethod.GET);
            OpenApiSpecPoeticInvoker.addOperation(endpointOperationMap, path, item.getDelete(), HttpMethod.DELETE);
            OpenApiSpecPoeticInvoker.addOperation(endpointOperationMap, path, item.getPost(), HttpMethod.POST);
            OpenApiSpecPoeticInvoker.addOperation(endpointOperationMap, path, item.getPut(), HttpMethod.PUT);
            OpenApiSpecPoeticInvoker.addOperation(endpointOperationMap, path, item.getPatch(), HttpMethod.PATCH);
        }
        return new OpenApiSpecPoeticInvoker(Collections.unmodifiableMap(endpointOperationMap), validator);
    }

    private static void addOperation(Map<String, EndpointOperation> endpointOperationMap, String path, Operation operation, HttpMethod method) {
        if (operation == null) {
            return;
        }
        endpointOperationMap.put(operation.getOperationId(), new EndpointOperation(path, method, operation));
    }

    @Override
    public Object invokeOrThrow(HttpPoet poet, String methodName, Object[] args, MissingMethodException e) throws IOException {
        EndpointOperation op = this.endpointOperationMap.get(methodName);
        if (op == null) {
            throw e;
        }
        Map<?, ?> additionalParams = this.getAdditionalParams(args);
        String resolvedPath = this.resolvePath(op, args);
        com.atlassian.oai.validator.model.Request request = this.toRequest(poet, op, resolvedPath, additionalParams);
        ValidationReport validationReport = this.validator.validateRequest(request);
        if (validationReport.hasErrors()) {
            StringBuilder messageBuilder = new StringBuilder();
            for (ValidationReport.Message message : validationReport.getMessages()) {
                messageBuilder.append(message.getMessage()).append("\n");
            }
            throw new IllegalArgumentException(messageBuilder.toString());
        }
        return poet.method(additionalParams, resolvedPath, op.getMethod());
    }

    private com.atlassian.oai.validator.model.Request toRequest(HttpPoet poet, EndpointOperation op, String resolvedPath, Map<?, ?> additionalParams) {
        Request okHttpRequest = poet.request(op.getMethod(), resolvedPath, additionalParams);
        HttpUrl url = okHttpRequest.url();
        SimpleRequest.Builder builder = new SimpleRequest.Builder(Request.Method.valueOf((String)op.getMethod().toString()), resolvedPath);
        for (int i = 0; i < url.querySize(); ++i) {
            builder.withQueryParam(url.queryParameterName(i), new String[]{url.queryParameterValue(i)});
        }
        if (okHttpRequest.body() != null) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            BufferedSink buffer = Okio.buffer((Sink)Okio.sink((OutputStream)bos));
            okHttpRequest.body().writeTo(buffer);
            buffer.flush();
            builder.withBody(bos.toByteArray());
        }
        return builder.build();
    }

    private String resolvePath(EndpointOperation op, Object[] args) {
        List pathParameters;
        String path = op.getPath();
        List list = pathParameters = op.getOperation().getParameters() != null ? op.getOperation().getParameters().stream().filter(p -> "path".equals(p.getIn())).collect(Collectors.toList()) : Collections.emptyList();
        if (pathParameters.isEmpty()) {
            return path;
        }
        StringBuffer buffer = new StringBuffer();
        Matcher matcher = PATH_VARIABLE_PATTERN.matcher(path);
        int i = 0;
        List pathVariables = Arrays.stream(args).filter(o -> !(o instanceof Map)).collect(Collectors.toList());
        while (matcher.find()) {
            if (i >= pathVariables.size()) {
                throw new IllegalArgumentException(String.format("Path variable '%s' (%s) is missing", ((Parameter)pathParameters.get(i)).getName(), ((Parameter)pathParameters.get(i)).getSchema().getType()));
            }
            String r = String.valueOf(pathVariables.get(i));
            matcher.appendReplacement(buffer, r);
            ++i;
        }
        if (i != pathParameters.size()) {
            throw new IllegalArgumentException("There's too much arguments");
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    private Map<?, ?> getAdditionalParams(Object[] args) {
        return Arrays.stream(args).filter(a -> a instanceof Map).findFirst().orElse(Collections.emptyMap());
    }

    public List<String> listOperations() {
        return this.endpointOperationMap.keySet().stream().sorted().collect(Collectors.toList());
    }

    public EndpointOperation getOperation(String name) {
        return this.endpointOperationMap.get(name);
    }

    public OpenApiSpecPoeticInvoker(Map<String, EndpointOperation> endpointOperationMap, OpenApiInteractionValidator validator) {
        this.endpointOperationMap = endpointOperationMap;
        this.validator = validator;
    }

    public static final class EndpointOperation {
        private final String path;
        private final HttpMethod method;
        private final Operation operation;

        public EndpointOperation(String path, HttpMethod method, Operation operation) {
            this.path = path;
            this.method = method;
            this.operation = operation;
        }

        public String getPath() {
            return this.path;
        }

        public HttpMethod getMethod() {
            return this.method;
        }

        public Operation getOperation() {
            return this.operation;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EndpointOperation)) {
                return false;
            }
            EndpointOperation other = (EndpointOperation)o;
            String this$path = this.getPath();
            String other$path = other.getPath();
            if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
                return false;
            }
            HttpMethod this$method = this.getMethod();
            HttpMethod other$method = other.getMethod();
            if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
                return false;
            }
            Operation this$operation = this.getOperation();
            Operation other$operation = other.getOperation();
            return !(this$operation == null ? other$operation != null : !this$operation.equals(other$operation));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            HttpMethod $method = this.getMethod();
            result = result * 59 + ($method == null ? 43 : $method.hashCode());
            Operation $operation = this.getOperation();
            result = result * 59 + ($operation == null ? 43 : $operation.hashCode());
            return result;
        }

        public String toString() {
            return "OpenApiSpecPoeticInvoker.EndpointOperation(path=" + this.getPath() + ", method=" + this.getMethod() + ", operation=" + this.getOperation() + ")";
        }
    }
}

