/*
 * Decompiled with CFR 0.152.
 */
package com.tananaev.adblib;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class AdbProtocol {
    public static final int ADB_HEADER_LENGTH = 24;
    public static final int CMD_SYNC = 1129208147;
    public static final int CMD_CNXN = 1314410051;
    public static final int CONNECT_VERSION = 0x1000000;
    public static final int CONNECT_MAXDATA = 4096;
    public static byte[] CONNECT_PAYLOAD;
    public static final int CMD_AUTH = 1213486401;
    public static final int AUTH_TYPE_TOKEN = 1;
    public static final int AUTH_TYPE_SIGNATURE = 2;
    public static final int AUTH_TYPE_RSA_PUBLIC = 3;
    public static final int CMD_OPEN = 1313165391;
    public static final int CMD_OKAY = 1497451343;
    public static final int CMD_CLSE = 1163086915;
    public static final int CMD_WRTE = 1163154007;

    private static int getPayloadChecksum(byte[] payload) {
        int checksum = 0;
        for (byte b : payload) {
            if (b >= 0) {
                checksum += b;
                continue;
            }
            checksum += b + 256;
        }
        return checksum;
    }

    public static boolean validateMessage(AdbMessage msg) {
        if (msg.command != ~msg.magic) {
            return false;
        }
        return msg.payloadLength == 0 || AdbProtocol.getPayloadChecksum(msg.payload) == msg.checksum;
    }

    public static byte[] generateMessage(int cmd, int arg0, int arg1, byte[] payload) {
        ByteBuffer message = payload != null ? ByteBuffer.allocate(24 + payload.length).order(ByteOrder.LITTLE_ENDIAN) : ByteBuffer.allocate(24).order(ByteOrder.LITTLE_ENDIAN);
        message.putInt(cmd);
        message.putInt(arg0);
        message.putInt(arg1);
        if (payload != null) {
            message.putInt(payload.length);
            message.putInt(AdbProtocol.getPayloadChecksum(payload));
        } else {
            message.putInt(0);
            message.putInt(0);
        }
        message.putInt(~cmd);
        if (payload != null) {
            message.put(payload);
        }
        return message.array();
    }

    public static byte[] generateConnect() {
        return AdbProtocol.generateMessage(1314410051, 0x1000000, 4096, CONNECT_PAYLOAD);
    }

    public static byte[] generateAuth(int type, byte[] data) {
        return AdbProtocol.generateMessage(1213486401, type, 0, data);
    }

    public static byte[] generateOpen(int localId, String dest) throws UnsupportedEncodingException {
        ByteBuffer bbuf = ByteBuffer.allocate(dest.length() + 1);
        bbuf.put(dest.getBytes("UTF-8"));
        bbuf.put((byte)0);
        return AdbProtocol.generateMessage(1313165391, localId, 0, bbuf.array());
    }

    public static byte[] generateWrite(int localId, int remoteId, byte[] data) {
        return AdbProtocol.generateMessage(1163154007, localId, remoteId, data);
    }

    public static byte[] generateClose(int localId, int remoteId) {
        return AdbProtocol.generateMessage(1163086915, localId, remoteId, null);
    }

    public static byte[] generateReady(int localId, int remoteId) {
        return AdbProtocol.generateMessage(1497451343, localId, remoteId, null);
    }

    static {
        try {
            CONNECT_PAYLOAD = "host::\u0000".getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    static final class AdbMessage {
        public int command;
        public int arg0;
        public int arg1;
        public int payloadLength;
        public int checksum;
        public int magic;
        public byte[] payload;

        AdbMessage() {
        }

        public static AdbMessage parseAdbMessage(InputStream in) throws IOException {
            int bytesRead;
            AdbMessage msg = new AdbMessage();
            ByteBuffer packet = ByteBuffer.allocate(24).order(ByteOrder.LITTLE_ENDIAN);
            int dataRead = 0;
            do {
                if ((bytesRead = in.read(packet.array(), dataRead, 24 - dataRead)) >= 0) continue;
                throw new IOException("Stream closed");
            } while ((dataRead += bytesRead) < 24);
            msg.command = packet.getInt();
            msg.arg0 = packet.getInt();
            msg.arg1 = packet.getInt();
            msg.payloadLength = packet.getInt();
            msg.checksum = packet.getInt();
            msg.magic = packet.getInt();
            if (msg.payloadLength != 0) {
                msg.payload = new byte[msg.payloadLength];
                dataRead = 0;
                do {
                    if ((bytesRead = in.read(msg.payload, dataRead, msg.payloadLength - dataRead)) >= 0) continue;
                    throw new IOException("Stream closed");
                } while ((dataRead += bytesRead) < msg.payloadLength);
            }
            return msg;
        }
    }
}

