/*
 * Decompiled with CFR 0.152.
 */
package com.tananaev.adblib;

import com.tananaev.adblib.AdbAuthenticationFailedException;
import com.tananaev.adblib.AdbCrypto;
import com.tananaev.adblib.AdbProtocol;
import com.tananaev.adblib.AdbStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.Socket;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class AdbConnection
implements Closeable {
    private Socket socket;
    private int lastLocalId = 0;
    private volatile InputStream inputStream;
    volatile OutputStream outputStream;
    private volatile Thread connectionThread;
    private volatile boolean connectAttempted;
    private volatile boolean abortOnUnauthorised;
    private volatile boolean authorisationFailed;
    private volatile boolean connected;
    private volatile int maxData;
    private volatile AdbCrypto crypto;
    private boolean sentSignature;
    private volatile ConcurrentHashMap<Integer, AdbStream> openStreams = new ConcurrentHashMap();

    private AdbConnection() {
        this.connectionThread = this.createConnectionThread();
    }

    public static AdbConnection create(Socket socket, AdbCrypto crypto) throws IOException {
        AdbConnection newConn = new AdbConnection();
        newConn.crypto = crypto;
        newConn.socket = socket;
        newConn.inputStream = socket.getInputStream();
        newConn.outputStream = socket.getOutputStream();
        socket.setTcpNoDelay(true);
        return newConn;
    }

    private Thread createConnectionThread() {
        final AdbConnection conn = this;
        return new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!AdbConnection.this.connectionThread.isInterrupted()) {
                    try {
                        AdbProtocol.AdbMessage msg = AdbProtocol.AdbMessage.parseAdbMessage(AdbConnection.this.inputStream);
                        if (!AdbProtocol.validateMessage(msg)) continue;
                        switch (msg.command) {
                            case 1163086915: 
                            case 1163154007: 
                            case 1497451343: {
                                AdbStream waitingStream;
                                if (!conn.connected || (waitingStream = (AdbStream)AdbConnection.this.openStreams.get(msg.arg1)) == null) break;
                                AdbStream adbStream = waitingStream;
                                synchronized (adbStream) {
                                    if (msg.command == 1497451343) {
                                        waitingStream.updateRemoteId(msg.arg0);
                                        waitingStream.readyForWrite();
                                        waitingStream.notify();
                                    } else if (msg.command == 1163154007) {
                                        waitingStream.addPayload(msg.payload);
                                        waitingStream.sendReady();
                                    } else if (msg.command == 1163086915) {
                                        conn.openStreams.remove(msg.arg1);
                                        waitingStream.notifyClose(true);
                                    }
                                    break;
                                }
                            }
                            case 1213486401: {
                                byte[] packet;
                                if (msg.arg0 != 1) break;
                                if (conn.sentSignature) {
                                    if (AdbConnection.this.abortOnUnauthorised) {
                                        AdbConnection.this.authorisationFailed = true;
                                        throw new RuntimeException();
                                    }
                                    packet = AdbProtocol.generateAuth(3, conn.crypto.getAdbPublicKeyPayload());
                                } else {
                                    packet = AdbProtocol.generateAuth(2, conn.crypto.signAdbTokenPayload(msg.payload));
                                    conn.sentSignature = true;
                                }
                                Closeable closeable = conn.outputStream;
                                synchronized (closeable) {
                                    conn.outputStream.write(packet);
                                    conn.outputStream.flush();
                                    break;
                                }
                            }
                            case 1314410051: {
                                Closeable closeable = conn;
                                synchronized (closeable) {
                                    conn.maxData = msg.arg1;
                                    conn.connected = true;
                                    conn.notifyAll();
                                    break;
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                        break;
                    }
                }
                AdbConnection adbConnection = conn;
                synchronized (adbConnection) {
                    AdbConnection.this.cleanupStreams();
                    conn.notifyAll();
                    conn.connectAttempted = false;
                }
            }
        });
    }

    public int getMaxData() throws InterruptedException, IOException {
        if (!this.connectAttempted) {
            throw new IllegalStateException("connect() must be called first");
        }
        this.waitForConnection(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        return this.maxData;
    }

    public void connect() throws IOException, InterruptedException {
        this.connect(Long.MAX_VALUE, TimeUnit.MILLISECONDS, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean connect(long timeout, TimeUnit unit, boolean throwOnUnauthorised) throws IOException, InterruptedException, AdbAuthenticationFailedException {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        OutputStream outputStream = this.outputStream;
        synchronized (outputStream) {
            this.outputStream.write(AdbProtocol.generateConnect());
            this.outputStream.flush();
        }
        this.connectAttempted = true;
        this.abortOnUnauthorised = throwOnUnauthorised;
        this.authorisationFailed = false;
        this.connectionThread.start();
        return this.waitForConnection(timeout, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AdbStream open(String destination) throws UnsupportedEncodingException, IOException, InterruptedException {
        int localId = ++this.lastLocalId;
        if (!this.connectAttempted) {
            throw new IllegalStateException("connect() must be called first");
        }
        this.waitForConnection(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        AdbStream stream = new AdbStream(this, localId);
        this.openStreams.put(localId, stream);
        Closeable closeable = this.outputStream;
        synchronized (closeable) {
            this.outputStream.write(AdbProtocol.generateOpen(localId, destination));
            this.outputStream.flush();
        }
        closeable = stream;
        synchronized (closeable) {
            stream.wait();
        }
        if (stream.isClosed()) {
            throw new ConnectException("Stream open actively rejected by remote peer");
        }
        return stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForConnection(long timeout, TimeUnit unit) throws InterruptedException, IOException {
        AdbConnection adbConnection = this;
        synchronized (adbConnection) {
            long timeoutEndMillis = System.currentTimeMillis() + unit.toMillis(timeout);
            while (!this.connected && this.connectAttempted && timeoutEndMillis - System.currentTimeMillis() > 0L) {
                this.wait(timeoutEndMillis - System.currentTimeMillis());
            }
            if (!this.connected) {
                if (this.connectAttempted) {
                    return false;
                }
                if (this.authorisationFailed) {
                    throw new AdbAuthenticationFailedException();
                }
                throw new IOException("Connection failed");
            }
        }
        return true;
    }

    private void cleanupStreams() {
        for (AdbStream s : this.openStreams.values()) {
            try {
                s.close();
            }
            catch (IOException iOException) {}
        }
        this.openStreams.clear();
    }

    @Override
    public void close() throws IOException {
        if (this.connectionThread == null) {
            return;
        }
        this.socket.close();
        this.connectionThread.interrupt();
        try {
            this.connectionThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

