/*
 * Decompiled with CFR 0.152.
 */
package com.tananaev.adblib;

import com.tananaev.adblib.AdbConnection;
import com.tananaev.adblib.AdbProtocol;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;

public class AdbStream
implements Closeable {
    private final AdbConnection adbConn;
    private final int localId;
    private volatile int remoteId;
    private final AtomicBoolean writeReady;
    private final Queue<byte[]> readQueue;
    private volatile boolean isClosed;
    private volatile boolean pendingClose;

    public AdbStream(AdbConnection adbConn, int localId) {
        this.adbConn = adbConn;
        this.localId = localId;
        this.readQueue = new ConcurrentLinkedQueue<byte[]>();
        this.writeReady = new AtomicBoolean(false);
        this.isClosed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addPayload(byte[] payload) {
        Queue<byte[]> queue = this.readQueue;
        synchronized (queue) {
            this.readQueue.add(payload);
            this.readQueue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendReady() throws IOException {
        byte[] packet = AdbProtocol.generateReady(this.localId, this.remoteId);
        OutputStream outputStream = this.adbConn.outputStream;
        synchronized (outputStream) {
            this.adbConn.outputStream.write(packet);
            this.adbConn.outputStream.flush();
        }
    }

    void updateRemoteId(int remoteId) {
        this.remoteId = remoteId;
    }

    void readyForWrite() {
        this.writeReady.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyClose(boolean closedByPeer) {
        if (closedByPeer && !this.readQueue.isEmpty()) {
            this.pendingClose = true;
        } else {
            this.isClosed = true;
        }
        Object object = this;
        synchronized (object) {
            this.notifyAll();
        }
        object = this.readQueue;
        synchronized (object) {
            this.readQueue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] read() throws InterruptedException, IOException {
        byte[] data = null;
        Queue<byte[]> queue = this.readQueue;
        synchronized (queue) {
            while ((data = this.readQueue.poll()) == null && !this.isClosed) {
                this.readQueue.wait();
            }
            if (this.isClosed) {
                throw new IOException("Stream closed");
            }
            if (this.pendingClose && this.readQueue.isEmpty()) {
                this.isClosed = true;
            }
        }
        return data;
    }

    public void write(String payload) throws IOException, InterruptedException {
        this.write(payload.getBytes("UTF-8"), false);
        this.write(new byte[]{0}, true);
    }

    public void write(byte[] payload) throws IOException, InterruptedException {
        this.write(payload, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] payload, boolean flush) throws IOException, InterruptedException {
        AdbStream adbStream = this;
        synchronized (adbStream) {
            while (!this.isClosed && !this.writeReady.compareAndSet(true, false)) {
                this.wait();
            }
            if (this.isClosed) {
                throw new IOException("Stream closed");
            }
        }
        byte[] packet = AdbProtocol.generateWrite(this.localId, this.remoteId, payload);
        OutputStream outputStream = this.adbConn.outputStream;
        synchronized (outputStream) {
            this.adbConn.outputStream.write(packet);
            if (flush) {
                this.adbConn.outputStream.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        AdbStream adbStream = this;
        synchronized (adbStream) {
            if (this.isClosed) {
                return;
            }
            this.notifyClose(false);
        }
        byte[] packet = AdbProtocol.generateClose(this.localId, this.remoteId);
        OutputStream outputStream = this.adbConn.outputStream;
        synchronized (outputStream) {
            this.adbConn.outputStream.write(packet);
            this.adbConn.outputStream.flush();
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }
}

