package com.tangzc.autotable.annotation.enums;

/**
 * <p>索引类型，目前仅支持两种类型：
 * <p>1、普通索引</p>
 * <p>2、唯一索引</p>
 *
 * @author don
 */
public enum IndexTypeEnum {

    /**
     * <p>普通索引
     * <p>最基本的索引类型，它没有任何限制，唯一任务就是加快系统对数据的访问速度。普通索引允许在定义索引的列中插入重复值和空值。
     */
    NORMAL,
    /**
     * <p>唯一索引与普通索引类似，不同的是创建唯一性索引的目的不是为了提高访问速度，而是为了避免数据出现重复。
     * <p>唯一索引列的值必须唯一，允许有空值。如果是组合索引，则列值的组合必须唯一。
     */
    UNIQUE
}
