/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.autotable.core;

import com.tangzc.autotable.annotation.AutoTable;
import com.tangzc.autotable.annotation.Ignore;
import com.tangzc.autotable.annotation.TableComment;
import com.tangzc.autotable.annotation.TableName;
import com.tangzc.autotable.core.AutoTableGlobalConfig;
import com.tangzc.autotable.core.Banner;
import com.tangzc.autotable.core.RunMode;
import com.tangzc.autotable.core.config.PropertyConfig;
import com.tangzc.autotable.core.dynamicds.IDataSourceHandler;
import com.tangzc.autotable.core.strategy.IStrategy;
import com.tangzc.autotable.core.strategy.mysql.MysqlStrategy;
import com.tangzc.autotable.core.strategy.pgsql.PgsqlStrategy;
import com.tangzc.autotable.core.strategy.sqlite.SqliteStrategy;
import com.tangzc.autotable.core.utils.ClassScanner;
import com.tangzc.autotable.core.utils.TableBeanUtils;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoTableBootstrap {
    private static final Logger log = LoggerFactory.getLogger(AutoTableBootstrap.class);

    public static void start() {
        PropertyConfig autoTableProperties = AutoTableGlobalConfig.getAutoTableProperties();
        if (autoTableProperties.getMode() == RunMode.none || !autoTableProperties.getEnable().booleanValue()) {
            return;
        }
        if (autoTableProperties.getShowBanner().booleanValue()) {
            Banner.print();
        }
        long start = System.currentTimeMillis();
        AutoTableGlobalConfig.addStrategy(new MysqlStrategy());
        AutoTableGlobalConfig.addStrategy(new PgsqlStrategy());
        AutoTableGlobalConfig.addStrategy(new SqliteStrategy());
        String[] packs = AutoTableBootstrap.getModelPackage(autoTableProperties);
        HashSet<Class<? extends Annotation>> includeAnnotations = new HashSet<Class<? extends Annotation>>(Arrays.asList(TableName.class, TableComment.class, AutoTable.class));
        includeAnnotations.addAll(AutoTableGlobalConfig.getAutoTableOrmFrameAdapter().scannerAnnotations());
        HashSet<Class<? extends Annotation>> ignoreAnnotations = new HashSet<Class<? extends Annotation>>(Collections.singleton(Ignore.class));
        AutoTableGlobalConfig.getAutoTableAnnotationInterceptor().intercept(includeAnnotations, ignoreAnnotations);
        Set<Class<?>> classes = ClassScanner.scan(packs, includeAnnotations, ignoreAnnotations);
        IDataSourceHandler datasourceHandler = AutoTableGlobalConfig.getDatasourceHandler();
        datasourceHandler.handleAnalysis(classes, (databaseDialect, entityClasses) -> {
            Map<String, List<Class>> repeatCheckMap = entityClasses.stream().collect(Collectors.groupingBy(entity -> TableBeanUtils.getTableSchema(entity) + "." + TableBeanUtils.getTableName(entity)));
            for (Map.Entry<String, List<Class>> repeatCheckItem : repeatCheckMap.entrySet()) {
                int sameTableNameCount = repeatCheckItem.getValue().size();
                if (sameTableNameCount <= 1) continue;
                String tableName = repeatCheckItem.getKey();
                throw new RuntimeException(String.format("\u5b58\u5728\u91cd\u540d\u7684\u8868\uff1a%s(%s)\uff0c\u8bf7\u68c0\u67e5\uff01", tableName, String.join((CharSequence)",", repeatCheckItem.getValue().stream().map(Class::getName).collect(Collectors.toSet()))));
            }
            IStrategy<?, ?, ?> databaseStrategy = AutoTableGlobalConfig.getStrategy(databaseDialect);
            if (databaseStrategy != null) {
                for (Class entityClass : entityClasses) {
                    databaseStrategy.start(entityClass);
                }
            } else {
                log.warn("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u6570\u636e\u5e93\uff08{}\uff09\u65b9\u8a00\u7b56\u7565\uff0c\u65e0\u6cd5\u81ea\u52a8\u7ef4\u62a4\u8868\u7ed3\u6784", databaseDialect);
            }
        });
        log.info("AutoTable\u6267\u884c\u7ed3\u675f\u3002\u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - start));
    }

    private static String[] getModelPackage(PropertyConfig autoTableProperties) {
        String[] packs = autoTableProperties.getModelPackage();
        if (packs == null) {
            packs = new String[]{AutoTableBootstrap.getBootPackage()};
        }
        return packs;
    }

    private static String getBootPackage() {
        StackTraceElement[] stackTrace;
        for (StackTraceElement stackTraceElement : stackTrace = new RuntimeException().getStackTrace()) {
            if (!"main".equals(stackTraceElement.getMethodName())) continue;
            String mainClassName = stackTraceElement.getClassName();
            int lastDotIndex = mainClassName.lastIndexOf(".");
            return lastDotIndex != -1 ? mainClassName.substring(0, lastDotIndex) : "";
        }
        throw new RuntimeException("\u672a\u627e\u5230\u4e3b\u9ed8\u8ba4\u5305");
    }
}

