/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.autotable.core.builder;

import com.tangzc.autotable.annotation.ColumnDefault;
import com.tangzc.autotable.annotation.enums.DefaultValueEnum;
import com.tangzc.autotable.core.AutoTableGlobalConfig;
import com.tangzc.autotable.core.converter.DatabaseTypeAndLength;
import com.tangzc.autotable.core.strategy.ColumnMetadata;
import com.tangzc.autotable.core.utils.TableBeanUtils;
import java.lang.reflect.Field;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnMetadataBuilder {
    private static final Logger log = LoggerFactory.getLogger(ColumnMetadataBuilder.class);
    protected final String databaseDialect;

    public ColumnMetadataBuilder(String databaseDialect) {
        this.databaseDialect = databaseDialect;
    }

    public <T extends ColumnMetadata> List<T> buildList(Class<?> clazz, List<Field> fields) {
        AtomicInteger index = new AtomicInteger(1);
        List columnMetadata = fields.stream().filter(field -> TableBeanUtils.isIncludeField(field, clazz)).map(field -> this.build(clazz, (Field)field, index.getAndIncrement())).collect(Collectors.toList());
        if (columnMetadata.isEmpty()) {
            log.warn("\u626b\u63cf\u53d1\u73b0{}\u6ca1\u6709\u5efa\u8868\u5b57\u6bb5\u8bf7\u6ce8\u610f\uff01", (Object)clazz.getName());
        }
        return columnMetadata;
    }

    public ColumnMetadata build(Class<?> clazz, Field field, int position) {
        ColumnMetadata columnMetadata = this.newColumnMetadata();
        DatabaseTypeAndLength typeAndLength = this.getTypeAndLength(this.databaseDialect, clazz, field);
        columnMetadata.setName(TableBeanUtils.getRealColumnName(clazz, field)).setComment(TableBeanUtils.getComment(field, clazz)).setType(typeAndLength).setNotNull(TableBeanUtils.isNotNull(field, clazz)).setPrimary(TableBeanUtils.isPrimary(field, clazz)).setAutoIncrement(TableBeanUtils.isAutoIncrement(field, clazz));
        ColumnDefault columnDefault = TableBeanUtils.getDefaultValue(field);
        if (columnDefault != null) {
            DefaultValueEnum defaultValueType = columnDefault.type();
            columnMetadata.setDefaultValueType(defaultValueType);
            String defaultValue = this.getDefaultValue(typeAndLength, columnDefault);
            columnMetadata.setDefaultValue(defaultValue);
        }
        this.customBuild(columnMetadata, clazz, field, position);
        return columnMetadata;
    }

    protected void customBuild(ColumnMetadata columnMetadata, Class<?> clazz, Field field, int position) {
    }

    protected DatabaseTypeAndLength getTypeAndLength(String databaseDialect, Class<?> clazz, Field field) {
        return AutoTableGlobalConfig.getJavaTypeToDatabaseTypeConverter().convert(databaseDialect, clazz, field);
    }

    protected String getDefaultValue(DatabaseTypeAndLength typeAndLength, ColumnDefault columnDefault) {
        String defaultValue = columnDefault.value();
        if (defaultValue != null && defaultValue.isEmpty()) {
            defaultValue = null;
        }
        return defaultValue;
    }

    protected ColumnMetadata newColumnMetadata() {
        return new ColumnMetadata();
    }
}

